/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.exception.BladeException;
import com.blade.kit.BladeCache;
import com.blade.kit.BladeKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.HttpRequest;
import com.blade.mvc.http.HttpResponse;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.http.Session;
import com.blade.server.netty.RouteMethodHandler;
import com.blade.server.netty.StaticFileHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerDispatcher
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerDispatcher.class);
    private final Set<String> statics = WebContext.blade().getStatics();
    private final ExceptionHandler exceptionHandler = WebContext.blade().exceptionHandler();
    private final StaticFileHandler staticFileHandler = new StaticFileHandler(WebContext.blade());
    private final RouteMethodHandler routeMethodHandler = new RouteMethodHandler();
    private final String sessionKey = WebContext.blade().environment().get("http.session.key", "SESSION");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        String remoteAddress = ctx.channel().remoteAddress().toString();
        boolean isStatic = false;
        Instant start = null;
        if (WebContext.blade().allowCost()) {
            start = Instant.now();
        }
        HttpRequest request = HttpRequest.build(req, remoteAddress);
        HttpResponse response = new HttpResponse();
        String uri = request.uri();
        String method = BladeCache.getPaddingMethod(request.method());
        WebContext.set(new WebContext(request, response));
        try {
            if (this.isStaticFile(uri)) {
                this.staticFileHandler.handle(ctx, (Request)request, (Response)response);
                isStatic = true;
            } else {
                this.routeMethodHandler.handle(ctx, (Request)request, (Response)response);
            }
            if (WebContext.blade().allowCost()) {
                long cost = BladeKit.log200(log, start, method, uri);
                request.attribute("costTime", cost);
            }
        }
        catch (Exception e) {
            this.exceptionCaught(uri, method, e);
        }
        finally {
            if (!isStatic) {
                this.finishWrite(ctx, request, response);
            }
            WebContext.remove();
        }
    }

    private void finishWrite(ChannelHandlerContext ctx, Request request, Response response) {
        Session session = request.session();
        if (null != session) {
            Cookie cookie = new Cookie();
            cookie.name(this.sessionKey);
            cookie.value(session.id());
            cookie.httpOnly(true);
            cookie.secure(request.isSecure());
            response.cookie(cookie);
        }
        this.routeMethodHandler.handleResponse(request, response, ctx);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.isResetByPeer(cause)) {
            log.error(cause.getMessage(), cause);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)500));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private boolean isStaticFile(String uri) {
        Optional<String> result = this.statics.stream().filter(s -> s.equals(uri) || uri.startsWith((String)s)).findFirst();
        return result.isPresent();
    }

    private void exceptionCaught(String uri, String method, Exception e) {
        if (!(e instanceof BladeException)) {
            BladeKit.log500(log, method, uri);
        }
        if (null != this.exceptionHandler) {
            this.exceptionHandler.handle(e);
        } else {
            log.error("Request Exception", (Throwable)e);
        }
    }
}

