/*
 * Decompiled with CFR 0.152.
 */
package com.blade.validator;

import com.blade.exception.ValidatorException;
import com.blade.kit.BladeKit;
import com.blade.validator.TypeFunction;

public class ValidationResult {
    private boolean valid;
    private String message;
    private String code;

    public static ValidationResult ok() {
        return new ValidationResult(true, null, null);
    }

    public static ValidationResult ok(String code) {
        return new ValidationResult(true, null, code);
    }

    public static ValidationResult fail(String message) {
        return new ValidationResult(false, message, null);
    }

    public static ValidationResult fail(String code, String message) {
        return new ValidationResult(false, message, code);
    }

    public void throwIfInvalid() {
        this.throwMessage(this.getMessage());
    }

    public void throwIfInvalid(String fieldName) {
        if (!this.isValid()) {
            throw new ValidatorException(fieldName + " " + this.getMessage());
        }
    }

    public <T, R> void throwIfInvalid(TypeFunction<T, R> function) {
        String fieldName = BladeKit.getLambdaFieldName(function);
        this.throwIfInvalid(fieldName);
    }

    public void throwMessage(String msg) {
        if (!this.isValid()) {
            throw new ValidatorException(msg);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValid() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    public String toString() {
        return "ValidationResult(valid=" + this.isValid() + ", message=" + this.getMessage() + ", code=" + this.getCode() + ")";
    }

    public ValidationResult(boolean valid, String message, String code) {
        this.valid = valid;
        this.message = message;
        this.code = code;
    }
}

