/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.dataplatform.taskmamager;

import com.chinamcloud.bigdata.common.http.utils.HttpRequestSetter;
import com.chinamcloud.bigdata.common.http.utils.HttpUtils;
import com.chinamcloud.bigdata.dataplatform.taskmamager.config.HiveConfig;
import com.chinamcloud.bigdata.dataplatform.taskmamager.maindb.bean.ConnectionInfo;
import com.chinamcloud.bigdata.dataplatform.taskmamager.maindb.bean.ConnectionResponseResult;
import com.chinamcloud.bigdata.dataplatform.taskmamager.maindb.bean.DBInfo;
import com.chinamcloud.bigdata.dataplatform.taskmamager.maindb.bean.DBResponseResult;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HiveDBManager {
    private ObjectMapper mapper = new ObjectMapper();
    private String queryConnectionInfoUrl;
    private String queryDBInfoUrl;

    public HiveDBManager(HiveConfig hiveConfig) {
        this.queryConnectionInfoUrl = hiveConfig.getQueryConnectionInfoUrl();
        this.queryDBInfoUrl = hiveConfig.getQueryDBInfoUrl();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public String getQueryConnectionInfoUrl() {
        return this.queryConnectionInfoUrl;
    }

    public String getQueryDBInfoUrl() {
        return this.queryDBInfoUrl;
    }

    public void setQueryConnectionInfoUrl(String queryConnectionInfoUrl) {
        this.queryConnectionInfoUrl = queryConnectionInfoUrl;
    }

    public void setQueryDBInfoUrl(String queryDBInfoUrl) {
        this.queryDBInfoUrl = queryDBInfoUrl;
    }

    public DBInfo queryDBInfo(String dbId) {
        String result = HttpUtils.executeGet((String)(this.queryDBInfoUrl + "/" + dbId), null, (HttpRequestSetter[])new HttpRequestSetter[0]);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            DBResponseResult dbResult = this.parseResponseResult(result, DBResponseResult.class);
            if ("200".equals(dbResult.getCode())) {
                return (DBInfo)dbResult.getData();
            }
            throw new RuntimeException("query dbinfo result code is[" + dbResult.getCode() + "] message[" + dbResult.getMessage() + "]");
        }
        throw new RuntimeException("query dbinfo result is blank!");
    }

    public ConnectionInfo queryConnectionInfo(String clusterId) {
        String result = HttpUtils.executeGet((String)this.queryConnectionInfoUrl, null, (HttpRequestSetter[])new HttpRequestSetter[0]);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            ConnectionResponseResult dbResult = this.parseResponseResult(result, ConnectionResponseResult.class);
            if ("200".equals(dbResult.getCode())) {
                List connectionInfos = (List)dbResult.getData();
                ConnectionInfo clusterConnnectionInfo = null;
                for (ConnectionInfo connectionInfo : connectionInfos) {
                    if (!clusterId.equals(connectionInfo.getClusterId())) continue;
                    clusterConnnectionInfo = connectionInfo;
                    break;
                }
                if (clusterConnnectionInfo == null) {
                    throw new RuntimeException("query connectioninfo can not found connection info!clusterId[" + clusterId + "]");
                }
                return clusterConnnectionInfo;
            }
            throw new RuntimeException("query connectioninfo result code is[" + dbResult.getCode() + "] message[" + dbResult.getMessage() + "]");
        }
        throw new RuntimeException("query connectioninfo result is blank!");
    }

    private <T> T parseResponseResult(String result, Class<T> clazz) {
        if (!StringUtils.isBlank((CharSequence)result)) {
            try {
                return (T)this.mapper.readerFor(clazz).readValue(result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

