/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.dataplatform.taskmamager;

import com.chinamcloud.bigdata.common.http.utils.HttpRequestSetter;
import com.chinamcloud.bigdata.common.http.utils.HttpUtils;
import com.chinamcloud.bigdata.dataplatform.taskmamager.config.TaskConfig;
import com.chinamcloud.bigdata.dataplatform.taskmamager.dolphinscheduler.bean.ExecuteType;
import com.chinamcloud.bigdata.dataplatform.taskmamager.dolphinscheduler.bean.PageInfo;
import com.chinamcloud.bigdata.dataplatform.taskmamager.dolphinscheduler.bean.ProcessDefinition;
import com.chinamcloud.bigdata.dataplatform.taskmamager.dolphinscheduler.bean.ProcessInstance;
import com.chinamcloud.bigdata.dataplatform.taskmamager.dolphinscheduler.bean.ResponseResult;
import com.chinamcloud.bigdata.dataplatform.taskmamager.dolphinscheduler.bean.RunDefinition;
import com.chinamcloud.bigdata.dataplatform.taskmamager.dolphinscheduler.bean.ScheduleParam;
import com.chinamcloud.bigdata.dataplatform.taskmamager.dolphinscheduler.bean.TaskInstance;
import com.chinamcloud.bigdata.dataplatform.taskmamager.result.Result;
import com.chinamcloud.bigdata.dataplatform.taskmamager.result.ResultCode;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskManager {
    private String definitionRunUrl;
    private String definitionSaveUrl;
    private String executorsExecuteUrl;
    private ObjectMapper mapper = new ObjectMapper();
    private String processInstancePageUrl;
    private String queryLogDetailUrl;
    private String queryTaskByCommandIdUrl;
    private String taskInstanceUrl;
    private String token;
    private static final Logger log = LogManager.getLogger(TaskManager.class);
    private String scheduleOfflineUrl;
    private String scheduleOnlineUrl;
    private String scheduleCreateUrl;
    private String scheduleUpdateUrl;

    public TaskManager(TaskConfig taskConfig) {
        this.token = taskConfig.getToken();
        this.definitionSaveUrl = taskConfig.getDefinitionSaveUrl();
        this.definitionRunUrl = taskConfig.getDefinitionRunUrl();
        this.queryLogDetailUrl = taskConfig.getQueryLogDetailUrl();
        this.queryTaskByCommandIdUrl = taskConfig.getQueryTaskByCommandIdUrl();
        this.processInstancePageUrl = taskConfig.getProcessInstancePageUrl();
        this.taskInstanceUrl = taskConfig.getTaskInstanceUrl();
        this.executorsExecuteUrl = taskConfig.getExecutorsExecuteUrl();
        this.scheduleOfflineUrl = taskConfig.getScheduleOfflineUrl();
        this.scheduleOnlineUrl = taskConfig.getScheduleOnlineUrl();
        this.scheduleCreateUrl = taskConfig.getScheduleCreateUrl();
        this.scheduleUpdateUrl = taskConfig.getScheduleUpdateUrl();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public Result<?> addTask(ProcessDefinition processDefinition) throws Exception {
        return this.addTask(this.token, processDefinition);
    }

    public Result<?> addTask(final String token, ProcessDefinition processDefinition) throws Exception {
        this.checkToken(token);
        ObjectWriter writer = this.mapper.writer();
        String processDefinitionStr = writer.writeValueAsString((Object)processDefinition.getProcessDefinitionJson());
        String locations = writer.writeValueAsString(processDefinition.getLocations());
        String connects = writer.writeValueAsString(processDefinition.getConnects());
        LinkedList<String> params = new LinkedList<String>();
        params.add("name=" + processDefinition.getName());
        params.add("alias=" + processDefinition.getAlias());
        params.add("processDefinitionJson=" + processDefinitionStr);
        params.add("locations=" + locations);
        params.add("connects=" + connects);
        params.add("description=" + processDefinition.getDescription());
        String queryParam = StringUtils.join(params, (String)"&");
        log.debug("addTask url[" + this.definitionSaveUrl + "] params[" + queryParam + "]");
        String result = (String)HttpUtils.executePost((String)this.definitionSaveUrl, (String)queryParam, (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int statusCode = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("statusCode[" + statusCode + "] result[" + result + "]");
                if (statusCode == 201) {
                    return result;
                }
                return null;
            }
        }, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        log.debug("response result[" + result + "]");
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                return Result.result(ResultCode.OK, responseResult.getData());
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    private void checkToken(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("token is blank");
        }
    }

    public String getDefinitionRunUrl() {
        return this.definitionRunUrl;
    }

    public String getExecutorsExecuteUrl() {
        return this.executorsExecuteUrl;
    }

    private boolean isSuccess(ResponseResult responseResult) {
        return responseResult != null && "0".equals(responseResult.getCode());
    }

    private ResponseResult parseResponseResult(String result) {
        if (!StringUtils.isBlank((CharSequence)result)) {
            try {
                return (ResponseResult)this.mapper.readerFor(ResponseResult.class).readValue(result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Result<?> queryLogDetail(Integer taskId, Integer pos, Integer limit) {
        return this.queryLogDetail(this.token, taskId, pos, limit);
    }

    public Result<?> queryLogDetail(final String token, Integer taskId, Integer pos, Integer limit) {
        this.checkToken(token);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskInstId", String.valueOf(taskId));
        params.put("skipLineNum", String.valueOf(pos));
        params.put("limit", String.valueOf(limit));
        log.debug("queryLogDetail url[" + this.queryLogDetailUrl + "] params[" + params + "]");
        String result = (String)HttpUtils.executeGet((String)this.queryLogDetailUrl, params, (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int statusCode = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("statusCode[" + statusCode + "] result[" + result + "]");
                if (statusCode == 200) {
                    return result;
                }
                return null;
            }
        }, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                return Result.result(ResultCode.OK, responseResult.getData());
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    public Result<?> queryProcessInstancePageList(Long definitionId, String startTime, String endTime, ExecutionStatus statType, Integer pageNo, Integer pageSize) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processDefinitionId", String.valueOf(definitionId));
        if (!StringUtils.isBlank((CharSequence)startTime)) {
            params.put("startDate", startTime);
        }
        if (!StringUtils.isBlank((CharSequence)endTime)) {
            params.put("endDate", endTime);
        }
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        try {
            log.debug("queryProcessInstancePageList url[" + this.processInstancePageUrl + "] params[" + this.mapper.writeValueAsString(params) + "]");
        }
        catch (JsonProcessingException e1) {
            e1.printStackTrace();
        }
        String result = HttpUtils.executeGet((String)this.processInstancePageUrl, params, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", TaskManager.this.token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                try {
                    String data = this.mapper.writer().writeValueAsString(responseResult.getData());
                    log.debug("result[" + data + "]");
                    PageInfo pageInfo = (PageInfo)this.mapper.readerFor((TypeReference)new TypeReference<PageInfo<ProcessInstance>>(){}).readValue(data);
                    return Result.result(ResultCode.OK, pageInfo);
                }
                catch (IOException e) {
                    return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
                }
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    public Result<?> queryTaskByCommandId(Integer commandId, String searchName, String subId) {
        return this.queryTaskByCommandId(this.token, commandId, searchName, subId);
    }

    public Result<?> queryTaskByCommandId(final String token, Integer commandId, String searchName, String subId) {
        this.checkToken(token);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("commandId", String.valueOf(commandId));
        params.put("taskName", searchName);
        params.put("subId", subId);
        String result = (String)HttpUtils.executeGet((String)this.queryTaskByCommandIdUrl, params, (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int statusCode = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("statusCode[" + statusCode + "] result[" + result + "]");
                if (statusCode == 200) {
                    return result;
                }
                return null;
            }
        }, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", token);
                base.setHeader("content-type", "application/x-www-form-urlencoded");
            }
        }});
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                return Result.result(ResultCode.OK, responseResult.getData());
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    public Result<?> queryTaskInstancePageList(Integer processInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", String.valueOf(processInstanceId));
        String result = HttpUtils.executeGet((String)this.taskInstanceUrl, params, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", TaskManager.this.token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        log.debug("result[" + result + "]");
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                try {
                    Map<String, Object> values = responseResult.getData();
                    String data = this.mapper.writer().writeValueAsString(values.get("taskList"));
                    List pageInfo = (List)this.mapper.readerFor((TypeReference)new TypeReference<List<TaskInstance>>(){}).readValue(data);
                    return Result.result(ResultCode.OK, pageInfo);
                }
                catch (IOException e) {
                    return Result.result(ResultCode.ERROR_CODE, "response parse failed!because result is null");
                }
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    public Result<?> runDefinition(RunDefinition runDefinition) {
        return this.runTask(this.token, runDefinition);
    }

    public Result<?> runTask(final String token, RunDefinition runDefinition) {
        this.checkToken(token);
        LinkedList<String> params = new LinkedList<String>();
        params.add("processDefinitionId=" + runDefinition.getProcessDefinitionId());
        params.add("scheduleTime=" + runDefinition.getScheduleTime());
        params.add("failureStrategy=" + runDefinition.getFailureStrategy());
        params.add("warningType=" + runDefinition.getWarningType());
        params.add("warningGroupId=" + runDefinition.getWarningGroupId());
        params.add("execType=" + runDefinition.getExecType());
        params.add("startNodeList=" + runDefinition.getStartNodeList());
        params.add("taskDependType=" + runDefinition.getTaskDependType());
        params.add("runMode=" + runDefinition.getRunMode());
        params.add("processInstancePriority=" + (Object)((Object)runDefinition.getProcessInstancePriority()));
        params.add("receivers=" + runDefinition.getReceivers());
        params.add("receiversCc=" + runDefinition.getReceiversCc());
        params.add("workerGroupId=" + runDefinition.getWorkerGroupId());
        params.add("content=" + runDefinition.getContent());
        String queryParam = StringUtils.join(params, (String)"&");
        String result = HttpUtils.executePost((String)this.definitionRunUrl, (String)queryParam, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        log.debug("runTask result=" + result);
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                return Result.result(ResultCode.OK, responseResult.getData());
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed!because result is null");
    }

    public Result<?> executorExcute(String processInstanceId, ExecuteType executeType) {
        return this.executorExcute(this.token, processInstanceId, executeType);
    }

    public Result<?> executorExcute(final String token, String processInstanceId, ExecuteType executeType) {
        this.checkToken(token);
        LinkedList<String> params = new LinkedList<String>();
        params.add("processInstanceId=" + processInstanceId);
        params.add("executeType=" + executeType.name());
        log.debug("executorsExecuteUrl[" + this.executorsExecuteUrl + "] params[" + StringUtils.join(params, (String)"&") + "]");
        String result = (String)HttpUtils.executePost((String)this.executorsExecuteUrl, (String)StringUtils.join(params, (String)"&"), (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                Integer statusCode = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("statusCode[" + statusCode + "] result[" + result + "]");
                System.out.println("statusCode[" + statusCode + "] result[" + result + "]");
                if (statusCode == 200) {
                    return result;
                }
                return null;
            }
        }, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess;
            boolean bl = isSuccess = this.isSuccess(responseResult) || responseResult != null && "50006".equals(responseResult.getCode());
            if (isSuccess) {
                return Result.result(ResultCode.OK, responseResult.getData());
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    public Result<?> createSchedule(final String token, Integer processDefinitionId, ScheduleParam schedule, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, String receivers, String receiversCc, String workerGroupId, Priority processInstancePriority) {
        this.checkToken(token);
        LinkedList<String> params = new LinkedList<String>();
        params.add("processDefinitionId=" + String.valueOf(processDefinitionId));
        try {
            params.add("schedule=" + this.mapper.writeValueAsString((Object)schedule));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        params.add("warningType=" + warningType.name());
        params.add("warningGroupId=" + warningGroupId);
        params.add("failureStrategy=" + failureStrategy.name());
        params.add("receivers=" + receivers);
        params.add("receiversCc=" + receiversCc);
        params.add("workerGroupId=" + workerGroupId);
        params.add("processInstancePriority=" + processInstancePriority.name());
        String result = (String)HttpUtils.executePost((String)this.scheduleCreateUrl, (String)StringUtils.join(params, (String)"&"), (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int statusCode = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("statusCode[" + statusCode + "] result[" + result + "]");
                if (statusCode == 201) {
                    return result;
                }
                return null;
            }
        }, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        log.debug("createSchedule result[" + result + "]");
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                return Result.result(ResultCode.OK, responseResult.getData());
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    public Result<?> createSchedule(Integer processDefinitionId, ScheduleParam schedule, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, String receivers, String receiversCc, String workerGroupId, Priority processInstancePriority) {
        return this.createSchedule(this.token, processDefinitionId, schedule, warningType, warningGroupId, failureStrategy, receivers, receiversCc, workerGroupId, processInstancePriority);
    }

    public Result<?> updateSchedule(final String token, Integer id, ScheduleParam schedule, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, String receivers, String receiversCc, String workerGroupId, Priority processInstancePriority) {
        this.checkToken(token);
        LinkedList<String> params = new LinkedList<String>();
        params.add("id=" + id);
        try {
            params.add("schedule=" + this.mapper.writeValueAsString((Object)schedule));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        params.add("warningType=" + warningType.name());
        params.add("warningGroupId=" + warningGroupId);
        params.add("failureStrategy=" + failureStrategy.name());
        params.add("receivers=" + receivers);
        params.add("receiversCc=" + receiversCc);
        params.add("workerGroupId=" + workerGroupId);
        params.add("processInstancePriority=" + processInstancePriority.name());
        log.debug("updateSchedule url[" + this.scheduleUpdateUrl + "] params[" + StringUtils.join(params, (String)"&") + "]");
        String result = (String)HttpUtils.executePost((String)this.scheduleUpdateUrl, (String)StringUtils.join(params, (String)"&"), (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int statusCode = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("statusCode[" + statusCode + "] result[" + result + "]");
                if (statusCode == 200) {
                    return result;
                }
                return null;
            }
        }, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                return Result.result(ResultCode.OK, responseResult.getData());
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    public Result<?> updateSchedule(Integer id, ScheduleParam schedule, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, String receivers, String receiversCc, String workerGroupId, Priority processInstancePriority) {
        return this.updateSchedule(this.token, id, schedule, warningType, warningGroupId, failureStrategy, receivers, receivers, workerGroupId, processInstancePriority);
    }

    public Result<?> offlineSchedule(final String token, Integer id) {
        this.checkToken(token);
        LinkedList<String> params = new LinkedList<String>();
        params.add("id=" + id);
        log.debug("offlineSchedule url[" + this.scheduleOfflineUrl + "] params[" + StringUtils.join(params, (String)"&") + "]");
        String result = (String)HttpUtils.executePost((String)this.scheduleOfflineUrl, (String)StringUtils.join(params, (String)"&"), (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int statusCode = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("statusCode[" + statusCode + "] result[" + result + "]");
                if (statusCode == 200) {
                    return result;
                }
                return null;
            }
        }, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        log.debug("offlineSchedule result[" + result + "]");
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                return Result.result(ResultCode.OK, responseResult.getData());
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    public Result<?> onlineSchedule(final String token, Integer id) {
        this.checkToken(token);
        LinkedList<String> params = new LinkedList<String>();
        params.add("id=" + id);
        log.debug("onlineSchedule url[" + this.scheduleOnlineUrl + "] params[" + StringUtils.join(params, (String)"&") + "]");
        String result = (String)HttpUtils.executePost((String)this.scheduleOnlineUrl, (String)StringUtils.join(params, (String)"&"), (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int statusCode = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("statusCode[" + statusCode + "] result[" + result + "]");
                if (statusCode == 200) {
                    return result;
                }
                return null;
            }
        }, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase base) {
                base.setHeader("token", token);
                base.setHeader("content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            }
        }});
        log.debug("onlineSchedule result[" + result + "]");
        ResponseResult responseResult = this.parseResponseResult(result);
        if (responseResult != null) {
            boolean isSuccess = this.isSuccess(responseResult);
            if (isSuccess) {
                return Result.result(ResultCode.OK, responseResult.getData());
            }
            return Result.result(ResultCode.ERROR_CODE, responseResult.getData());
        }
        return Result.result(ResultCode.ERROR_CODE, "response parse failed is null");
    }

    public Result<?> onlineSchedule(Integer id) {
        return this.onlineSchedule(this.token, id);
    }

    public Result<?> offlineSchedule(Integer id) {
        return this.offlineSchedule(this.token, id);
    }

    public void setDefinitionRunUrl(String definitionRunUrl) {
        this.definitionRunUrl = definitionRunUrl;
    }

    public void setExecutorsExecuteUrl(String executorsExecuteUrl) {
        this.executorsExecuteUrl = executorsExecuteUrl;
    }
}

