/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.dataplatform.taskmamager.result;

import com.chinamcloud.bigdata.dataplatform.taskmamager.result.ResultCode;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Result<T> {
    private Integer code;
    @JsonProperty(value="message")
    private String msg;
    private T data;

    public void setData(T data) {
        this.data = data;
    }

    public static <T> Result<?> success(T data) {
        return Result.result(ResultCode.OK, data);
    }

    public static <T> Result<?> result(ResultCode code, T data) {
        return new Result<T>(code, data);
    }

    public Result() {
    }

    private Result(ResultCode rc) {
        this.code = rc.getCode();
        this.msg = rc.getMsg();
    }

    private Result(ResultCode rc, T data) {
        this(rc);
        this.data = data;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }
}

