/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.exception.MsgException;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.fasterxml.jackson.databind.JsonMappingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

@Component(value="handlerExceptionResolver")
public class ExceptionResolver
extends AbstractHandlerExceptionResolver {
    private static Logger logger = LogManager.getLogger(ExceptionResolver.class);

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        String contentType = request.getContentType();
        Throwable throwable = ex.getCause() != null ? ex.getCause() : ex;
        logger.error("global error", (Throwable)ex);
        String result = "";
        boolean isJson = false;
        result = this.getMsg(throwable);
        if (!StringUtils.isEmpty((CharSequence)contentType) && contentType.indexOf("application/json") >= 0) {
            isJson = true;
        }
        try {
            if (isJson) {
                response.setContentType("application/json");
                result = JSON.toJSONString((Object)CodeResult.failedResult(result));
            }
            response.getWriter().write(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getMsg(Throwable throwable) {
        if (throwable == null) {
            return MessageSource.getMsg("server_error");
        }
        if (throwable instanceof JsonMappingException || throwable instanceof MissingServletRequestParameterException || throwable instanceof HttpMessageNotReadableException) {
            return MessageSource.getMsg("params_error");
        }
        if (throwable instanceof HttpRequestMethodNotSupportedException) {
            return MessageSource.getMsg("not_support_request_method");
        }
        if (throwable instanceof MsgException) {
            return ((MsgException)throwable).getMessage();
        }
        return MessageSource.getMsg("server_error");
    }
}

