/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.bean;

import com.chinamcloud.bigdata.haiheservice.bean.KeyWords;
import com.chinamcloud.bigdata.haiheservice.converter.MonitorTopicSubConvert;
import com.chinamcloud.bigdata.haiheservice.converter.MonitorTopicTypeConvert;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="t_topic")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect
public class MonitorTopic {
    @Id
    private Long id;
    @Transient
    @JsonIgnore
    private List<KeyWords> keyWords;
    @JsonIgnore
    private Integer monitorTopicId;
    private String name;
    @JsonIgnore
    private Integer productId;
    @JsonUnwrapped
    @Transient
    private StatisticData statistic;
    @JsonUnwrapped
    @Transient
    private IndexData indexData;
    @Convert(converter=MonitorTopicSubConvert.class)
    @JsonIgnore
    private Subscribable subscribable;
    @Convert(converter=MonitorTopicTypeConvert.class)
    @JsonIgnore
    private Type type;
    private Long uid;
    @JsonIgnore
    @Transient
    private Date subEndTime;
    private Date registerTime;
    private Date createdAtTime;
    @Transient
    public byte owner;
    private Integer includeSearch;

    public IndexData getIndexData() {
        return this.indexData;
    }

    public void setIndexData(IndexData indexData) {
        this.indexData = indexData;
    }

    public Date getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Date getSubEndTime() {
        return this.subEndTime;
    }

    public void setSubEndTime(Date subEndTime) {
        this.subEndTime = subEndTime;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MonitorTopic) {
            MonitorTopic monitorTopic = (MonitorTopic)obj;
            return monitorTopic.getId().equals(this.id);
        }
        return false;
    }

    public Long getId() {
        return this.id;
    }

    public List<String> getKeyWord() {
        if (this.keyWords != null) {
            return this.keyWords.stream().map(x -> x.getKeyWord()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<KeyWords> getKeyWords() {
        return this.keyWords;
    }

    public Integer getMonitorTopicId() {
        return this.monitorTopicId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public Integer getSub() {
        if (this.registerTime != null && System.currentTimeMillis() - this.registerTime.getTime() > 172800000L) {
            return Subscribable.YES.value;
        }
        return this.subscribable.intValue();
    }

    public StatisticData getStatistic() {
        return this.statistic;
    }

    public Subscribable getSubscribable() {
        return this.subscribable;
    }

    public Type getType() {
        return this.type;
    }

    public Long getUid() {
        return this.uid;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setKeyWords(List<KeyWords> keyWords) {
        this.keyWords = keyWords;
    }

    public void setMonitorTopicId(Integer monitorTopicId) {
        this.monitorTopicId = monitorTopicId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public void setStatistic(StatisticData statistic) {
        this.statistic = statistic;
    }

    public void setSubscribable(Subscribable subscribable) {
        this.subscribable = subscribable;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public byte getOwner() {
        return this.owner;
    }

    public void setOwner(byte owner) {
        this.owner = owner;
    }

    public Integer getIncludeSearch() {
        return this.includeSearch;
    }

    public void setIncludeSearch(Integer includeSearch) {
        this.includeSearch = includeSearch;
    }

    public Date getCreatedAtTime() {
        return this.createdAtTime;
    }

    public void setCreatedAtTime(Date createdAtTime) {
        this.createdAtTime = createdAtTime;
    }

    public static class IndexData {
        private int docTotal;
        private int hotTotal;
        private int emotionTotal;
        private int mediaCoverTotal;
        private int preDocCount;
        private int yesterdayDocCount;
        private int preHotValue;
        private int yesterdayHotValue;
        private int preMediaCover;
        private int yesterdayMediaCover;
        private int preEmotionValue;
        private int yesterdayEmotionValue;

        public int getDocTotal() {
            return this.docTotal;
        }

        public void setDocTotal(int docTotal) {
            this.docTotal = docTotal;
        }

        public int getHotTotal() {
            return this.hotTotal;
        }

        public void setHotTotal(int hotTotal) {
            this.hotTotal = hotTotal;
        }

        public int getEmotionTotal() {
            return this.emotionTotal;
        }

        public void setEmotionTotal(int emotionTotal) {
            this.emotionTotal = emotionTotal;
        }

        public int getMediaCoverTotal() {
            return this.mediaCoverTotal;
        }

        public void setMediaCoverTotal(int mediaCoverTotal) {
            this.mediaCoverTotal = mediaCoverTotal;
        }

        public int getPreDocCount() {
            return this.preDocCount;
        }

        public void setPreDocCount(int preDocCount) {
            this.preDocCount = preDocCount;
        }

        public int getYesterdayDocCount() {
            return this.yesterdayDocCount;
        }

        public void setYesterdayDocCount(int yesterdayDocCount) {
            this.yesterdayDocCount = yesterdayDocCount;
        }

        public int getPreHotValue() {
            return this.preHotValue;
        }

        public void setPreHotValue(int preHotValue) {
            this.preHotValue = preHotValue;
        }

        public int getYesterdayHotValue() {
            return this.yesterdayHotValue;
        }

        public void setYesterdayHotValue(int yesterdayHotValue) {
            this.yesterdayHotValue = yesterdayHotValue;
        }

        public int getPreMediaCover() {
            return this.preMediaCover;
        }

        public void setPreMediaCover(int preMediaCover) {
            this.preMediaCover = preMediaCover;
        }

        public int getYesterdayMediaCover() {
            return this.yesterdayMediaCover;
        }

        public void setYesterdayMediaCover(int yesterdayMediaCover) {
            this.yesterdayMediaCover = yesterdayMediaCover;
        }

        public int getPreEmotionValue() {
            return this.preEmotionValue;
        }

        public void setPreEmotionValue(int preEmotionValue) {
            this.preEmotionValue = preEmotionValue;
        }

        public int getYesterdayEmotionValue() {
            return this.yesterdayEmotionValue;
        }

        public void setYesterdayEmotionValue(int yesterdayEmotionValue) {
            this.yesterdayEmotionValue = yesterdayEmotionValue;
        }
    }

    public static class StatisticData {
        private int todayCount;
        private int todayEmotion;
        private int yesterdayCount;
        private int yesterdayEmotion;
        private int totalCount;
        private int totalEmotion;

        public int getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public int getTotalEmotion() {
            return this.totalEmotion;
        }

        public void setTotalEmotion(int totalEmotion) {
            this.totalEmotion = totalEmotion;
        }

        public int getTodayCount() {
            return this.todayCount;
        }

        public int getTodayEmotion() {
            return this.todayEmotion;
        }

        public int getYesterdayCount() {
            return this.yesterdayCount;
        }

        public int getYesterdayEmotion() {
            return this.yesterdayEmotion;
        }

        public void setTodayCount(int todayCount) {
            this.todayCount = todayCount;
        }

        public void setTodayEmotion(int todayEmotion) {
            this.todayEmotion = todayEmotion;
        }

        public void setYesterdayCount(int yesterdayCount) {
            this.yesterdayCount = yesterdayCount;
        }

        public void setYesterdayEmotion(int yesterdayEmotion) {
            this.yesterdayEmotion = yesterdayEmotion;
        }
    }

    public static enum Subscribable {
        NO(0),
        YES(1);

        private int value;

        public static Subscribable valueOfInt(int value) {
            switch (value) {
                case 0: {
                    return NO;
                }
                case 1: {
                    return YES;
                }
            }
            throw new RuntimeException("can not parse value " + value);
        }

        private Subscribable(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }
    }

    public static enum Type {
        CATEGORY(2),
        REGION(1),
        SYSTEM_DEFINE(3),
        USER_DEFINE(4);

        private int value;

        public static Type valueOfInt(int value) {
            switch (value) {
                case 1: {
                    return REGION;
                }
                case 2: {
                    return CATEGORY;
                }
                case 3: {
                    return SYSTEM_DEFINE;
                }
                case 4: {
                    return USER_DEFINE;
                }
            }
            throw new RuntimeException("can not parse value " + value);
        }

        private Type(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }
    }
}

