/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.NewsEmotionTendencyAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.SensitiveWordAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.AlarmWatchInfoBean;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.controller.TopicHotController;
import com.chinamcloud.bigdata.haiheservice.pojo.AlarmNewsParams;
import com.chinamcloud.bigdata.haiheservice.service.AlarmConfigService;
import com.chinamcloud.bigdata.haiheservice.util.TopicKeywordUtils;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/alarm"})
public class AlarmDetailController {
    private static Logger logger = LogManager.getLogger(TopicHotController.class);
    @Autowired
    private AlarmConfigService alarmConfigService;

    @RequestMapping(value={"/getNewsStatistic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getNewsStatistic(@Valid @RequestBody AlarmNewsParams params, BindingResult result, HttpServletRequest request) {
        Long taskId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            taskId = Long.valueOf(params.getTaskId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmConfigService.getWatchInfo(user.getId(), taskId);
        if (taskId == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
        params.setDescription(description);
        logger.info("description=" + description);
        params.setAfterProcessor(new NewsEmotionTendencyAfterProcessor());
        params.setFacetField("emotion_tendency");
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/news"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object hotNews(@RequestBody @Valid AlarmNewsParams params, BindingResult result, HttpServletRequest request) {
        Long taskId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            taskId = Long.valueOf(params.getTaskId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmConfigService.getWatchInfo(user.getId(), taskId);
        if (taskId == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
        params.setDescription(description);
        logger.info("description=" + description);
        String[] words = description.replace("AND", " ").replace("OR", " ").split(" ");
        params.setAfterProcessor(new SensitiveWordAfterProcessor(new HashSet<String>(Arrays.asList(words))));
        ModelAndView modelAndView = new ModelAndView("/es/basic/hotNews.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/getSenSourceFacet2"}, method={RequestMethod.POST})
    public Object getSenSourceFacet2(@Valid @RequestBody AlarmNewsParams params, BindingResult result, HttpServletRequest request) {
        Long taskId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            taskId = Long.valueOf(params.getTaskId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmConfigService.getWatchInfo(user.getId(), taskId);
        if (taskId == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
        params.setDescription(description);
        logger.info("description=" + description);
        params.setFacetField("tb_nickname");
        ModelAndView view = new ModelAndView("/es/basic/facetWithCondition.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getSenSourceFacet"}, method={RequestMethod.POST})
    public Object getSenSourceFacet(@Valid @RequestBody AlarmNewsParams params, BindingResult result, HttpServletRequest request) {
        Long taskId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            taskId = Long.valueOf(params.getTaskId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmConfigService.getWatchInfo(user.getId(), taskId);
        if (taskId == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
        params.setDescription(description);
        logger.info("description=" + description);
        params.setFacetField("tb_nickname");
        params.setFacetLimit(500);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }
}

