/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisRecord;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisReq;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisResult;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisTask;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.pojo.YCParams;
import com.chinamcloud.bigdata.haiheservice.service.AnalysisService;
import com.chinamcloud.bigdata.haiheservice.service.UserService;
import com.chinamcloud.bigdata.haiheservice.util.WeiboUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/analysis"})
public class AnalysisController {
    @Autowired
    AnalysisService analysisService;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    private static Logger logger = LogManager.getLogger(AnalysisController.class);

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    public Object list(@RequestBody Map<String, String> params, HttpServletRequest request) {
        String type = params.get("type");
        if (StringUtils.isEmpty((CharSequence)type)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        List<AnalysisRecord> result = this.analysisService.selectAnalysisRecordList(user.getId(), Integer.valueOf(type));
        return new CodeResult(CodeResult.Code.Success, result);
    }

    @RequestMapping(value={"/listReqTask"}, method={RequestMethod.POST})
    public Object listReqTask(@RequestBody Map<String, String> params, HttpServletRequest request) {
        String type = params.get("type");
        if (StringUtils.isEmpty((CharSequence)type)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        List<AnalysisReq> result = this.analysisService.selectAnalysisReqList(user.getId(), Integer.valueOf(type));
        return new CodeResult(CodeResult.Code.Success, result);
    }

    @RequestMapping(value={"/listReqStatus"}, method={RequestMethod.POST})
    public Object listReqStatus(@RequestBody Map<String, Object> params, HttpServletRequest request) {
        List ids = (List)params.get("ids");
        if (ids.isEmpty() || ids.size() == 0) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        List<AnalysisReq> result = this.analysisService.selectAnalysisReq(ids, user.getId());
        return new CodeResult(CodeResult.Code.Success, result);
    }

    @RequestMapping(value={"/listHistory"}, method={RequestMethod.POST})
    public Object listHistory(@RequestBody Map<String, String> params, HttpServletRequest request) {
        String url = params.get("url");
        String type = params.get("type");
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)type)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        List<AnalysisReq> records = this.analysisService.selectAnalysisReqHistoryList(user.getId(), url, Integer.valueOf(type));
        ArrayList modifyTimeList = new ArrayList();
        records.forEach(x -> modifyTimeList.add(x.getModifyTime()));
        return new CodeResult(CodeResult.Code.Success, modifyTimeList);
    }

    @RequestMapping(value={"/listHistoryResult"}, method={RequestMethod.POST})
    public Object listHistoryResult(@RequestBody Map<String, String> params, HttpServletRequest request) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String url = params.get("url");
        String type = params.get("type");
        String modifyTime = params.get("modifyTime");
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)type) || StringUtils.isEmpty((CharSequence)modifyTime)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        try {
            AnalysisResult result = this.analysisService.selectAnalysisResultHistory(user.getId(), url, Integer.valueOf(type), dateFormat.parse(modifyTime));
            Map map = (Map)JSON.parseObject((String)result.getResultJson(), Map.class);
            map.put("url", result.getUrl());
            if (result != null) {
                return new CodeResult(CodeResult.Code.Success, map, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed);
        }
        return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
    }

    @RequestMapping(value={"/analysisResult"}, method={RequestMethod.POST})
    public Object analysisDetail(@RequestBody Map<String, String> params, HttpServletRequest request) {
        String id = params.get("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        try {
            AnalysisResult result = this.analysisService.selectAnalysisResultById(Integer.valueOf(id), user.getId());
            Map map = (Map)JSON.parseObject((String)result.getResultJson(), Map.class);
            map.put("url", result.getUrl());
            if (result != null) {
                return new CodeResult(CodeResult.Code.Success, map, null);
            }
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("analysis_result_not_exist"));
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Object add(@RequestBody Map<String, String> params, HttpServletRequest request) throws Exception {
        final String url = params.get("url");
        final String type = params.get("type");
        if (StringUtils.isEmpty((CharSequence)url) || !"1".equals(type)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        if (!Pattern.compile("^https?://(www\\.)*weibo\\.com/(\\d{8,10})/(\\w{9}).*").matcher(url).matches()) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("error_url"));
        }
        Integer forwards = WeiboUtils.getWeiboForwards(url);
        if (forwards == null) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("weibo_forwords_get_error"));
        }
        if (forwards < 6) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("weibo_forwards_too_low"));
        }
        if (forwards > 100000) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("weibo_forwards_over_limit"));
        }
        final User user = (User)request.getAttribute("user");
        return this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<CodeResult>(){

            public CodeResult doInTransaction(TransactionStatus status) {
                try {
                    if (AnalysisController.this.analysisService.isAnalysisExisted(url, user.getId()) || AnalysisController.this.analysisService.isAnalysisReqExisted(url, user.getId())) {
                        return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("analysis_task_exist"));
                    }
                    AnalysisTask task = new AnalysisTask();
                    task.setOwnerId(user.getId());
                    task.setUrl(url);
                    task.setType(AnalysisTask.Type.valueOfInt(Integer.valueOf(type)));
                    AnalysisController.this.analysisService.addAnalysisTask(task);
                    AnalysisController.this.analysisService.addAnalysisReq(url, user.getId(), AnalysisTask.Type.valueOfInt(Integer.valueOf(type)));
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    throw e;
                }
                return new CodeResult(CodeResult.Code.Success, MessageSource.getMsg("analysis_task_add_success"));
            }
        });
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public Object delete(@RequestBody Map<String, String> params) throws Exception {
        String id = params.get("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        try {
            this.analysisService.deleteAnalysisReq(Long.valueOf(id));
        }
        catch (Exception e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        return new CodeResult(CodeResult.Code.Success);
    }

    @RequestMapping(value={"/reAnalysis"}, method={RequestMethod.POST})
    public Object reAnalyze(@RequestBody Map<String, String> params, HttpServletRequest request) throws Exception {
        String id = params.get("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        final User user = (User)request.getAttribute("user");
        AnalysisRecord record = null;
        try {
            record = this.analysisService.selectRecord(Long.valueOf(id), user.getId());
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        if (record == null) {
            return new CodeResult(CodeResult.Code.Failed, "record_not_exist");
        }
        final String url = record.getUrl();
        final AnalysisTask.Type type = record.getType();
        final AnalysisRecord record1 = record;
        return this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<CodeResult>(){

            public CodeResult doInTransaction(TransactionStatus status) {
                try {
                    if (AnalysisController.this.analysisService.isAnalysisExisted(url, user.getId())) {
                        return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("analysis_task_exist"));
                    }
                    AnalysisTask task = new AnalysisTask();
                    long recordId = 0L;
                    if (AnalysisTask.Type.YUAN_CHUANG == type) {
                        recordId = AnalysisController.this.analysisService.saveAnalysisRecordYC(record1);
                        task.setAnalisisId((int)recordId);
                    }
                    task.setOwnerId(user.getId());
                    task.setUrl(url);
                    task.setType(type);
                    AnalysisController.this.analysisService.addAnalysisTask(task);
                    AnalysisController.this.analysisService.updateReqPre(user.getId(), url, recordId, type);
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    throw e;
                }
                return new CodeResult(CodeResult.Code.Success, MessageSource.getMsg("analysis_task_add_success"));
            }
        });
    }

    @RequestMapping(value={"/ycdata"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object ycAnalysis(final @RequestBody YCParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        final User user = (User)request.getAttribute("user");
        if (user == null) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("user_not_exit"));
        }
        return this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<CodeResult>(){

            public CodeResult doInTransaction(TransactionStatus status) {
                try {
                    String url = params.getUrl();
                    Long ownerId = user.getId();
                    long reqId = AnalysisController.this.analysisService.addAnalysisReq(url, ownerId, AnalysisTask.Type.YUAN_CHUANG);
                    AnalysisRecord record = new AnalysisRecord();
                    record.setUrl(url);
                    record.setScreenName(params.getTitle());
                    record.setUid(params.getAuthor());
                    record.setSource(params.getSource());
                    record.setCreateAt(params.getCreateAt());
                    record.setDeadline(params.getDeadline());
                    record.setContent(params.getContent());
                    record.setProfileImageURL(StringUtils.join(params.getProfileImageURL(), (String)";"));
                    record.setThumbs(params.getThumbs().intValue());
                    record.setComments(params.getComments().intValue());
                    record.setRelaId(params.getRelaId());
                    record.setType(AnalysisTask.Type.YUAN_CHUANG);
                    record.setResultId(-1L);
                    record.setOwnerId(ownerId);
                    record.setStatus(2);
                    record.setForwards(0L);
                    record.setReads(params.getReads());
                    long recordId = AnalysisController.this.analysisService.saveAnalysisRecordYC(record);
                    if (recordId <= 0L) {
                        return new CodeResult(CodeResult.Code.Failed);
                    }
                    AnalysisController.this.analysisService.updateReqRecordId(record.getOwnerId(), record.getUrl(), recordId);
                    AnalysisTask task = new AnalysisTask();
                    task.setAnalisisId((int)recordId);
                    task.setOwnerId(ownerId);
                    task.setUrl(url);
                    task.setType(AnalysisTask.Type.valueOfInt(0));
                    AnalysisController.this.analysisService.addAnalysisTask(task);
                    return new CodeResult(CodeResult.Code.Success, reqId, MessageSource.getMsg("analysis_task_add_success"));
                }
                catch (Exception e) {
                    status.setRollbackOnly();
                    return new CodeResult(CodeResult.Code.Failed);
                }
            }
        });
    }

    @RequestMapping(value={"/getYcResult"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getYcResult(@RequestBody Map<String, String> params, HttpServletRequest request) {
        String id = params.get("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        if (user == null) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("user_not_exit"));
        }
        Long ownerId = user.getId();
        try {
            List<AnalysisReq> list = this.analysisService.selectReqStatus(Integer.valueOf(id), ownerId);
            if (list.size() == 0) {
                return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
            }
            AnalysisReq.Status status = list.get(0).getStatus();
            AnalysisResult result = null;
            if (status == AnalysisReq.Status.Success) {
                result = this.analysisService.selectAnalysisResultById(Integer.valueOf(id), ownerId);
                if (result != null) {
                    return new CodeResult(CodeResult.Code.Success, result.getResultJson(), null);
                }
                return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
            }
            if (status == AnalysisReq.Status.Running) {
                return new CodeResult(CodeResult.Code.AnalysisRunning, MessageSource.getMsg("analysis_task_is_running"));
            }
            if (status == AnalysisReq.Status.Failed) {
                return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("analysis_failed"));
            }
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
    }

    @RequestMapping(value={"/getArticleDetails"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getArticleDetails(@RequestBody Map<String, String> params, HttpServletRequest request) {
        String id = params.get("id");
        User user = (User)request.getAttribute("user");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        try {
            AnalysisRecord record = this.analysisService.selectRecord(Long.valueOf(id), user.getId());
            return new CodeResult(CodeResult.Code.Success, record);
        }
        catch (Exception e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }
}

