/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.pojo.HotNewsDetailParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.service.ArticleService;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/article"})
public class ArticleController {
    @Autowired
    private ArticleService service;
    private static Logger logger = LogManager.getLogger(ArticleController.class);

    @RequestMapping(value={"/exportData"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object exportData(@Valid @RequestBody HotNewsDetailParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.getErrorCount() > 0) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        long ownerId = user.getId();
        String docId = params.getDocId();
        this.service.exportData(ownerId, docId);
        return new CodeResult(CodeResult.Code.Success);
    }

    @RequestMapping(value={"/publishData"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object publishData(@Valid @RequestBody HotNewsDetailParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.getErrorCount() > 0) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        long ownerId = user.getId();
        String docId = params.getDocId();
        this.service.publishData(ownerId, docId);
        return new CodeResult(CodeResult.Code.Success);
    }

    @CrossOrigin(origins={"*"}, maxAge=3600L)
    @RequestMapping(value={"/detail"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object newsDetail(@RequestBody @Validated HotNewsDetailParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        try {
            hotParams.setId(params.getDocId());
        }
        catch (NumberFormatException e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ModelAndView view = new ModelAndView("/es/basic/newsDetail.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }
}

