/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.bean.ChargeAnalysisStatistic;
import com.chinamcloud.bigdata.haiheservice.bean.ChargeTopicSubStatistic;
import com.chinamcloud.bigdata.haiheservice.bean.StatisticTrend;
import com.chinamcloud.bigdata.haiheservice.bean.Trend;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.pojo.ChargeCurveStatisticParams;
import com.chinamcloud.bigdata.haiheservice.service.ChargeStatisticService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/charge"})
public class ChargeController {
    private final int statistic_day = 1;
    private final int statistic_hour = 0;
    private FastDateFormat dateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private FastDateFormat dateFormat1 = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:ss:mm");
    @Autowired
    private ChargeStatisticService service;
    private Function<ChargeCurveStatisticParams, Object[]> computeCurveParams = params -> {
        Date fromDt = params.getFromDt();
        Date toDt = params.getToDt();
        String dateType = params.getDateType();
        int statisticType = 1;
        if (fromDt != null && toDt != null) {
            try {
                fromDt = this.dateFormat1.parse(String.valueOf(this.dateFormat.format(fromDt)) + " 00:00:00");
                toDt = this.dateFormat1.parse(String.valueOf(this.dateFormat.format(toDt)) + " 23:59:59");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long diff = toDt.getTime() - fromDt.getTime();
            if (diff < 0L) {
                throw new RuntimeException("params_error");
            }
            if (diff < 86400000L) {
                statisticType = 0;
            }
        } else if (!StringUtils.isEmpty((CharSequence)dateType)) {
            if ("0".equals(dateType)) {
                statisticType = 0;
                toDt = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(toDt);
                calendar.add(6, -1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                fromDt = calendar.getTime();
            } else if ("1".equals(dateType)) {
                toDt = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(toDt);
                calendar.add(6, -7);
                fromDt = calendar.getTime();
            } else if ("2".equals(dateType)) {
                toDt = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(toDt);
                calendar.add(2, -1);
                fromDt = calendar.getTime();
            }
        } else {
            throw new RuntimeException("params_error");
        }
        return new Object[]{fromDt, toDt, statisticType};
    };

    @RequestMapping(value={"/newsStatistic"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object newsStatistic(@RequestBody @Validated ChargeCurveStatisticParams params, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        Object[] o = null;
        try {
            o = this.computeCurveParams.apply(params);
            Date fromDt = (Date)o[0];
            Date toDt = (Date)o[1];
            int statisticType = (Integer)o[2];
            List<Trend> trends = this.service.getNewsStatistic(user.getId(), fromDt, toDt, statisticType);
            StatisticTrend result = new StatisticTrend("newsStatistic", statisticType == 1 ? "day" : "hour", trends);
            return CodeResult.successResult(null, result);
        }
        catch (Exception e) {
            return CodeResult.failedResult(e.getMessage());
        }
    }

    @RequestMapping(value={"/dataStatistic"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object dataStatistic(@RequestBody @Validated ChargeCurveStatisticParams params, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        Object[] o = null;
        try {
            o = this.computeCurveParams.apply(params);
            Date fromDt = (Date)o[0];
            Date toDt = (Date)o[1];
            int statisticType = (Integer)o[2];
            List<Trend> trends = this.service.getDataStatistic(user.getId(), fromDt, toDt, statisticType);
            StatisticTrend result = new StatisticTrend("dataStatistic", statisticType == 1 ? "day" : "hour", trends);
            return CodeResult.successResult(null, result);
        }
        catch (Exception e) {
            return CodeResult.failedResult(e.getMessage());
        }
    }

    @RequestMapping(value={"/topicSubStatistic"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object topicSubStatistic(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        ChargeTopicSubStatistic statistic = this.service.getTopicStatistic(user.getId());
        return CodeResult.successResult(null, statistic);
    }

    @RequestMapping(value={"/analysisStatistic"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object analysisStatistic(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        ChargeAnalysisStatistic statistic = this.service.getAnalysisStatistic(user.getId());
        return CodeResult.successResult(null, statistic);
    }
}

