/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EmotionTendencyAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.CustomCloumnBean;
import com.chinamcloud.bigdata.haiheservice.bean.SiteStatistic;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.pojo.DirectSiteFacetParams;
import com.chinamcloud.bigdata.haiheservice.pojo.DirectSiteNewsParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotNewsDetailParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RelatedNewsParams;
import com.chinamcloud.bigdata.haiheservice.service.SiteStatisticService;
import com.chinamcloud.bigdata.haiheservice.util.ContainsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/directSite"})
public class DirectSiteController {
    private static Logger logger = LogManager.getLogger(DirectSiteController.class);
    private static Map<Integer, String> defaultSite = new HashMap<Integer, String>();
    @Autowired
    private SiteStatisticService service;

    static {
        defaultSite.put(4438, "\u4eba\u6c11\u65e5\u62a5");
        defaultSite.put(39, "\u65b0\u534e\u7f51");
        defaultSite.put(41649, "\u592e\u89c6\u7f51");
        defaultSite.put(4969, "\u592e\u5e7f\u7f51");
        defaultSite.put(7266, "\u51e4\u51f0\u7f51");
        defaultSite.put(954, "\u4e1c\u65b9\u7f51");
        defaultSite.put(4334, "\u5149\u660e\u7f51");
    }

    @RequestMapping(value={"/getSites"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object getSites(HttpServletRequest request) {
        List result;
        User user = (User)request.getAttribute("user");
        try {
            List<SiteStatistic> list = this.service.findSitesByUserId(user.getId());
            result = list.stream().filter(x -> !defaultSite.containsKey(x.getSourceId())).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult(null, result);
    }

    @RequestMapping(value={"/getSitesByCatId"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object getSitesByCatId(@RequestBody Map<String, String> values, HttpServletRequest request) {
        List<SiteStatistic> result;
        int intId;
        String id = values.get("catId");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            intId = Integer.valueOf(id);
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String column = values.get("column");
        User user = (User)request.getAttribute("user");
        try {
            result = this.service.findStatisticList(user.getId(), intId);
            if (!StringUtils.isEmpty((CharSequence)column) && !column.equals("\u5168\u90e8")) {
                List<String> list = this.service.findSitesByColumns(user.getId(), intId, column);
                result = result.stream().filter(x -> list.contains(String.valueOf(x.getSourceId()))).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult(null, result);
    }

    @RequestMapping(value={"/getColumnsByCatId"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object getColumnsByCatId(@RequestBody Map<String, String> values, HttpServletRequest request) {
        int intId;
        String id = values.get("catId");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            intId = Integer.valueOf(id);
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<Object> list = new ArrayList();
        User user = (User)request.getAttribute("user");
        try {
            list = this.service.getColumnsByCatId(user.getId(), intId);
            list.add(0, new CustomCloumnBean("\u5168\u90e8", "0"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult(null, list);
    }

    @RequestMapping(value={"/saveColumn"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object saveColumn(@RequestBody Map<String, String> values, HttpServletRequest request) {
        int catId;
        String id = values.get("catId");
        String column = values.get("column");
        String sourceIds = values.get("sourceIds");
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)column) || StringUtils.isEmpty((CharSequence)sourceIds)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            catId = Integer.valueOf(id);
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        try {
            this.service.saveColumn(user.getId(), catId, column, sourceIds);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult();
    }

    @RequestMapping(value={"/updateColumn"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object updateColumn(@RequestBody Map<String, String> values, HttpServletRequest request) {
        String column = values.get("column");
        String sourceIds = values.get("sourceIds");
        String cloumnId = values.get("cloumnId");
        if (StringUtils.isEmpty((CharSequence)column) || StringUtils.isEmpty((CharSequence)sourceIds) || StringUtils.isEmpty((CharSequence)cloumnId)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        try {
            this.service.updateColumn(user.getId(), column, sourceIds, cloumnId);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult();
    }

    @RequestMapping(value={"/deleteColumn"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object deleteColumn(@RequestBody Map<String, String> values, HttpServletRequest request) {
        String columnId = values.get("columnId");
        if (StringUtils.isEmpty((CharSequence)columnId)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        try {
            this.service.deleteColumn(user.getId(), columnId);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult();
    }

    @RequestMapping(value={"/news"})
    public Object hotNews(@RequestBody @Validated DirectSiteNewsParams params, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        String catId = params.getCatId();
        List<String> sourceIds = params.getSourceIds();
        if (sourceIds == null || sourceIds.size() == 0 || sourceIds.get(0).equals("-1")) {
            List<SiteStatistic> siteStatistics;
            try {
                siteStatistics = StringUtils.isEmpty((CharSequence)catId) ? this.service.findStatisticListByUserIds(user.getId()) : this.service.findStatisticList(user.getId(), Integer.valueOf(catId));
            }
            catch (NumberFormatException e) {
                return CodeResult.failedResultByMsgSource("params_error");
            }
            if (siteStatistics.size() == 0) {
                return CodeResult.successResult(null, Collections.emptyList());
            }
            Map<String, Integer> values = siteStatistics.stream().collect(Collectors.toMap(x -> String.valueOf(x.getSourceId()), x -> x.getSourceType()));
            params.setSourceIds(new ArrayList<String>(values.keySet()));
            ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
            view.addObject("params", (Object)params);
            return view;
        }
        List<SiteStatistic> siteStatistics = this.service.findStatisticListByUserIds(user.getId());
        Map<String, Integer> values = siteStatistics.stream().collect(Collectors.toMap(x -> String.valueOf(x.getSourceId()), x -> x.getSourceType()));
        if (!ContainsUtils.isSubset(values.keySet(), sourceIds)) {
            return CodeResult.failedResultByMsgSource("site_not_sub");
        }
        params.setSourceIds(sourceIds);
        ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/relatedNews"})
    public Object relatedNew(@RequestBody @Validated RelatedNewsParams params, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        hotParams.setClusterId(params.getClusterId());
        hotParams.setPage(params.getPage());
        hotParams.setSize(params.getSize());
        ModelAndView modelAndView = new ModelAndView("/es/basic/relatedNews.do");
        modelAndView.addObject("params", (Object)hotParams);
        return modelAndView;
    }

    @RequestMapping(value={"/newsDetail"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object newsDetail(@RequestBody @Validated HotNewsDetailParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        HotParams hotParams = new HotParams();
        try {
            hotParams.setId(params.getDocId());
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ModelAndView view = new ModelAndView("/es/basic/newsDetail.do");
        view.addObject("params", (Object)hotParams);
        view.addObject("user", (Object)user);
        return view;
    }

    @RequestMapping(value={"/getDayFacetBySite"}, method={RequestMethod.POST})
    public Object getDayFacetBySite(@Valid @RequestBody DirectSiteFacetParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        String souceId = params.getSourceId();
        List<SiteStatistic> siteStatistics = this.service.findStatisticListByUserIds(user.getId());
        List souceIds = siteStatistics.stream().map(x -> String.valueOf(x.getSourceId())).collect(Collectors.toList());
        if (!souceIds.contains(souceId)) {
            return CodeResult.failedResultByMsgSource("site_not_sub");
        }
        HotParams hotParams = new HotParams();
        hotParams.setDay("1");
        hotParams.setDateInterval("hour");
        hotParams.setFacetField("pubTimeStr");
        hotParams.setSourceIds(Arrays.asList(souceId));
        ModelAndView view = new ModelAndView("/es/basic/sentimentTrend.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getWeekFacetBySite"}, method={RequestMethod.POST})
    public Object getWeekFacetBySite(@Valid @RequestBody DirectSiteFacetParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        String souceId = params.getSourceId();
        List<SiteStatistic> siteStatistics = this.service.findStatisticListByUserIds(user.getId());
        List souceIds = siteStatistics.stream().map(x -> String.valueOf(x.getSourceId())).collect(Collectors.toList());
        if (!souceIds.contains(souceId)) {
            return CodeResult.failedResultByMsgSource("site_not_sub");
        }
        HotParams hotParams = new HotParams();
        hotParams.setDay("7");
        hotParams.setDateInterval("day");
        hotParams.setFacetField("pubTimeStr");
        hotParams.setSourceIds(Arrays.asList(souceId));
        ModelAndView view = new ModelAndView("/es/basic/sentimentTrend.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getEmotionTendency"}, method={RequestMethod.POST})
    public Object getEmotionTendency(@Valid @RequestBody DirectSiteFacetParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        String souceId = params.getSourceId();
        List<SiteStatistic> siteStatistics = this.service.findStatisticListByUserIds(user.getId());
        List souceIds = siteStatistics.stream().map(x -> String.valueOf(x.getSourceId())).collect(Collectors.toList());
        if (!souceIds.contains(souceId)) {
            return CodeResult.failedResultByMsgSource("site_not_sub");
        }
        HotParams hotParams = new HotParams();
        hotParams.setFacetField("emotion_tendency");
        hotParams.setSourceIds(Arrays.asList(souceId));
        EmotionTendencyAfterProcessor afterProcessor = new EmotionTendencyAfterProcessor();
        hotParams.setAfterProcessor(afterProcessor);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/statistic"})
    public Object statistic(@RequestBody @Validated DirectSiteNewsParams params, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        List<String> sourceIds = params.getSourceIds();
        List<SiteStatistic> siteStatistics = this.service.findStatisticListByUserIds(user.getId());
        Map<String, Integer> values = siteStatistics.stream().collect(Collectors.toMap(x -> String.valueOf(x.getSourceId()), x -> x.getSourceType()));
        if (!ContainsUtils.isSubset(values.keySet(), sourceIds)) {
            return CodeResult.failedResultByMsgSource("site_not_sub");
        }
        params.setSourceIds(sourceIds);
        params.setSize(0);
        ModelAndView view = new ModelAndView("/es/basic/statisticNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/export"})
    public Object export(@RequestBody @Validated DirectSiteNewsParams params, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        List<String> sourceIds = params.getSourceIds();
        List<SiteStatistic> siteStatistics = this.service.findStatisticListByUserIds(user.getId());
        Map<String, Integer> values = siteStatistics.stream().collect(Collectors.toMap(x -> String.valueOf(x.getSourceId()), x -> x.getSourceType()));
        if (!ContainsUtils.isSubset(values.keySet(), sourceIds)) {
            return CodeResult.failedResultByMsgSource("site_not_sub");
        }
        params.setSourceIds(sourceIds);
        ModelAndView view = new ModelAndView("/es/basic/exportNews.do");
        view.addObject("params", (Object)params);
        return view;
    }
}

