/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EmotionTendencyAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EventStatisticAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.TopicStatisticAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.KeyWords;
import com.chinamcloud.bigdata.haiheservice.bean.MonitorTopic;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.pojo.HotNewsDetailParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RelatedNewsParams;
import com.chinamcloud.bigdata.haiheservice.pojo.TopicHotEventParams;
import com.chinamcloud.bigdata.haiheservice.service.MonitorTopicService;
import com.chinamcloud.bigdata.haiheservice.util.TopicKeywordUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/topic"})
public class TopicHotController {
    private static Logger logger = LogManager.getLogger(TopicHotController.class);
    private static final List<Integer> productIds = new ArrayList<Integer>();
    @Autowired
    private MonitorTopicService monitorTopicService;

    static {
        productIds.add(53691);
        productIds.add(2762);
    }

    @RequestMapping(value={"/hotEvent"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object hotEvent(@RequestBody @Validated TopicHotEventParams params, BindingResult result, HttpServletRequest request) {
        Long topicId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        String description = TopicKeywordUtils.buildQueryByObject(keyWords);
        params.setDescription(description);
        params.setProduceIds(productIds);
        ModelAndView modelAndView = new ModelAndView("/es/basic/hotEvent.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/news"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object hotNews(@RequestBody @Validated TopicHotEventParams params, BindingResult result, HttpServletRequest request) {
        Long topicId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        String description = TopicKeywordUtils.buildQueryByObject(keyWords);
        params.setDescription(description);
        logger.info("description=" + description);
        params.setProduceIds(productIds);
        ModelAndView modelAndView = new ModelAndView("/es/basic/hotNews.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/relatedNews"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object relatedNew(@RequestBody @Validated RelatedNewsParams params, BindingResult result, HttpServletRequest request) {
        HotParams hotParams = new HotParams();
        hotParams.setClusterId(params.getClusterId());
        hotParams.setProduceIds(productIds);
        hotParams.setPage(params.getPage());
        hotParams.setSize(params.getSize());
        ModelAndView modelAndView = new ModelAndView("/es/basic/relatedNews.do");
        modelAndView.addObject("params", (Object)hotParams);
        return modelAndView;
    }

    @RequestMapping(value={"/newsDetail"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object newsDetail(@RequestBody @Validated HotNewsDetailParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        HotParams hotParams = new HotParams();
        try {
            hotParams.setId(params.getDocId());
        }
        catch (NumberFormatException e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ModelAndView view = new ModelAndView("/es/basic/newsDetail.do");
        hotParams.setProduceIds(productIds);
        view.addObject("params", (Object)hotParams);
        view.addObject("user", (Object)user);
        return view;
    }

    @RequestMapping(value={"/getHotWords"}, method={RequestMethod.POST})
    public Object getHotWords(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        HotParams hotParams = new HotParams();
        hotParams.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        hotParams.setProduceIds(productIds);
        hotParams.setFacetField("summary_keywords");
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getEmotionTendency"}, method={RequestMethod.POST})
    public Object getEmotionTendency(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        HotParams hotParams = new HotParams();
        hotParams.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        hotParams.setProduceIds(productIds);
        hotParams.setFacetField("emotion_tendency");
        EmotionTendencyAfterProcessor afterProcessor = new EmotionTendencyAfterProcessor();
        hotParams.setAfterProcessor(afterProcessor);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getTopicEmotionTrend"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getTopicEmotionTrend(@Validated @RequestBody RelatedNewsParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        hotParams.setProduceIds(productIds);
        hotParams.setClusterId(params.getClusterId());
        ArrayList<String> sortFields = new ArrayList<String>();
        sortFields.add("pubTime desc");
        hotParams.setSortFields(sortFields);
        ModelAndView view = new ModelAndView("/es/basic/topicEmotionTrend.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getSentimentTrend"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getSentimentTrend(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        HotParams hotParams = new HotParams();
        hotParams.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        hotParams.setProduceIds(productIds);
        hotParams.setDay("1");
        ModelAndView view = new ModelAndView("/es/basic/sentimentTrend.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getSenSourceFacet"}, method={RequestMethod.POST})
    public Object getSentimentSourceFacet(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setFacetField("tb_nickname");
        params.setFacetMincount(1);
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getSenSourceFacet2"}, method={RequestMethod.POST})
    public Object getSentimentSourceFacet2(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setFacetField("tb_nickname");
        params.setFacetMincount(1);
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/facetWithCondition.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getSenClassifyFacet"}, method={RequestMethod.POST})
    public Object getSenClassifyFacet(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setFacetField("source");
        params.setFacetMincount(1);
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getEventStatistics"}, method={RequestMethod.POST})
    public Object getEventStatistics(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(productIds);
        params.setAfterProcessor(new EventStatisticAfterProcessor());
        ModelAndView view = new ModelAndView("/es/basic/eventStatistics.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getEventTrend"}, method={RequestMethod.POST})
    public Object getEventTrend(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/eventTrend.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getTopicStatistics"}, method={RequestMethod.POST})
    public Object getTopicStatistics(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(productIds);
        params.setFacetMincount(1);
        params.setAfterProcessor(new TopicStatisticAfterProcessor());
        ModelAndView view = new ModelAndView("/es/basic/topicStatistics.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getRelatedTopic"}, method={RequestMethod.POST})
    public Object getRelatedTopic(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(productIds);
        params.setFacetMincount(1);
        ModelAndView view = new ModelAndView("/es/basic/hotTopic.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/clusterNews"}, method={RequestMethod.POST})
    public Object gethotNews(@Validated @RequestBody HotParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getTopicTrend"}, method={RequestMethod.POST})
    public Object getTopicTrend(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/topicTrend.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object export(@RequestBody @Validated TopicHotEventParams params, BindingResult result, HttpServletRequest request) {
        Long topicId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        String description = TopicKeywordUtils.buildQueryByObject(keyWords);
        params.setDescription(description);
        logger.info("description=" + description);
        params.setProduceIds(productIds);
        ModelAndView modelAndView = new ModelAndView("/es/basic/exportNews.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/statistic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object statistic(@RequestBody @Validated TopicHotEventParams params, BindingResult result, HttpServletRequest request) {
        Long topicId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        String description = TopicKeywordUtils.buildQueryByObject(keyWords);
        params.setDescription(description);
        logger.info("description=" + description);
        params.setProduceIds(productIds);
        params.setSize(0);
        ModelAndView modelAndView = new ModelAndView("/es/basic/statisticNews.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }
}

