/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.AlarmContactorBean;
import com.chinamcloud.bigdata.haiheservice.bean.AlarmWatchInfoBean;
import com.chinamcloud.bigdata.haiheservice.util.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class AlarmConfigDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public long saveContactor(AlarmContactorBean bean) {
        DBUtils.ParamSQLWrapper sqlWarpper = null;
        try {
            sqlWarpper = DBUtils.buildInsertSQL(bean);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        final DBUtils.ParamSQLWrapper tempWrapper = sqlWarpper;
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement statement = con.prepareStatement(tempWrapper.getSql(), 1);
                ArgumentPreparedStatementSetter statementSetter = new ArgumentPreparedStatementSetter(tempWrapper.getParamValues());
                statementSetter.setValues(statement);
                return statement;
            }
        }, (KeyHolder)keyHolder);
        long id = keyHolder.getKey().longValue();
        return id;
    }

    public boolean updateContactor(AlarmContactorBean bean) {
        DBUtils.ParamSQLWrapper sqlWarpper = null;
        try {
            sqlWarpper = DBUtils.buildUpdateSQL(bean);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        int num = this.jdbcTemplate.update(sqlWarpper.getSql(), sqlWarpper.getParamValues());
        return num == 1;
    }

    public boolean deleteContactor(long id) {
        int num = this.jdbcTemplate.update("delete from `t_alarm_contactor` WHERE id=?", new Object[]{id});
        return num == 1;
    }

    public List<AlarmContactorBean> getAllContactors(long userId) {
        String sql = "select contactor.* from `t_alarm_rule` rule join `t_alarm_contactor` contactor on rule.taskId = contactor.taskId where rule.userId = ?";
        return this.jdbcTemplate.query(sql, new Object[]{userId}, (RowMapper)new RowMapper<AlarmContactorBean>(){

            public AlarmContactorBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                AlarmContactorBean bean = new AlarmContactorBean();
                bean.setId(rs.getLong("id"));
                bean.setTaskId(rs.getLong("taskId"));
                bean.setContactor(rs.getString("contactor"));
                bean.setTelephone(rs.getString("telephone"));
                bean.setEmail(rs.getString("email"));
                return bean;
            }
        });
    }

    public List<AlarmContactorBean> getContactorsByTaskId(long userId, long taskId) {
        String sql = "select contactor.* from `t_alarm_rule` rule join `t_alarm_contactor` contactor on rule.taskId = contactor.taskId where rule.userId = ? and rule.taskId = ?";
        return this.jdbcTemplate.query(sql, new Object[]{userId, taskId}, (RowMapper)new RowMapper<AlarmContactorBean>(){

            public AlarmContactorBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                AlarmContactorBean bean = new AlarmContactorBean();
                bean.setId(rs.getLong("id"));
                bean.setTaskId(rs.getLong("taskId"));
                bean.setContactor(rs.getString("contactor"));
                bean.setTelephone(rs.getString("telephone"));
                bean.setEmail(rs.getString("email"));
                return bean;
            }
        });
    }

    public List<AlarmContactorBean> getContactorsByTaskId(long taskId) {
        String sql = "select contactor.* from `t_alarm_rule` rule join `t_alarm_contactor` contactor on rule.taskId = contactor.taskId where rule.taskId = ?";
        return this.jdbcTemplate.query(sql, new Object[]{taskId}, (RowMapper)new RowMapper<AlarmContactorBean>(){

            public AlarmContactorBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                AlarmContactorBean bean = new AlarmContactorBean();
                bean.setId(rs.getLong("id"));
                bean.setTaskId(rs.getLong("taskId"));
                bean.setContactor(rs.getString("contactor"));
                bean.setTelephone(rs.getString("telephone"));
                bean.setEmail(rs.getString("email"));
                return bean;
            }
        });
    }

    public long saveWatchInfo(AlarmWatchInfoBean bean) {
        DBUtils.ParamSQLWrapper sqlWarpper = null;
        try {
            sqlWarpper = DBUtils.buildInsertSQL(bean, false);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        final DBUtils.ParamSQLWrapper tempWrapper = sqlWarpper;
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement statement = con.prepareStatement(tempWrapper.getSql(), 1);
                ArgumentPreparedStatementSetter statementSetter = new ArgumentPreparedStatementSetter(tempWrapper.getParamValues());
                statementSetter.setValues(statement);
                return statement;
            }
        }, (KeyHolder)keyHolder);
        long taskId = keyHolder.getKey().longValue();
        return taskId;
    }

    public boolean updateWatchInfo(AlarmWatchInfoBean bean) {
        DBUtils.ParamSQLWrapper sqlWarpper = null;
        try {
            sqlWarpper = DBUtils.buildUpdateSQL(bean);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        int num = this.jdbcTemplate.update(sqlWarpper.getSql(), sqlWarpper.getParamValues());
        return num == 1;
    }

    public AlarmWatchInfoBean getWatchInfo(long userId, long taskId) {
        String sql = "select * from `t_alarm_rule` rule where rule.userId = ? and rule.taskId = ?";
        List beans = this.jdbcTemplate.query(sql, new Object[]{userId, taskId}, (RowMapper)new RowMapper<AlarmWatchInfoBean>(){

            public AlarmWatchInfoBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                AlarmWatchInfoBean bean = new AlarmWatchInfoBean();
                bean.setTaskId(rs.getLong("taskId"));
                bean.setUserId(rs.getLong("userId"));
                bean.setTitle(rs.getString("title"));
                bean.setKeyword(rs.getString("keyword"));
                bean.setDocValue(rs.getObject("docValue") != null ? rs.getString("docValue") : "");
                bean.setEmotionValueUpper(rs.getObject("emotionValueUpper") != null ? rs.getString("emotionValueUpper") : "");
                bean.setEmotionValueLower(rs.getObject("emotionValueLower") != null ? rs.getString("emotionValueLower") : "");
                bean.setMediaValue(rs.getObject("mediaValue") != null ? rs.getString("mediaValue") : "");
                return bean;
            }
        });
        return beans.size() > 0 ? (AlarmWatchInfoBean)beans.get(0) : null;
    }

    public List<AlarmWatchInfoBean> getWatchTask(long userId) {
        String sql = "select * from `t_alarm_rule` rule where rule.userId = ?";
        return this.jdbcTemplate.query(sql, new Object[]{userId}, (RowMapper)new RowMapper<AlarmWatchInfoBean>(){

            public AlarmWatchInfoBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                AlarmWatchInfoBean bean = new AlarmWatchInfoBean();
                bean.setTaskId(rs.getLong("taskId"));
                bean.setTitle(rs.getString("title"));
                bean.setKeyword(rs.getString("keyword"));
                bean.setStatus(rs.getInt("status"));
                return bean;
            }
        });
    }

    public List<AlarmWatchInfoBean> getWatchTaskWithContactors() {
        String sql = "select * from `t_alarm_rule` where status = 1";
        return this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<AlarmWatchInfoBean>(){

            public AlarmWatchInfoBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                AlarmWatchInfoBean bean = new AlarmWatchInfoBean();
                bean.setTaskId(rs.getLong("taskId"));
                bean.setKeyword(rs.getString("keyword"));
                bean.setDocValue(rs.getObject("docValue") != null ? rs.getString("docValue") : "");
                bean.setEmotionValueUpper(rs.getObject("emotionValueUpper") != null ? rs.getString("emotionValueUpper") : "");
                bean.setEmotionValueLower(rs.getObject("emotionValueLower") != null ? rs.getString("emotionValueLower") : "");
                bean.setMediaValue(rs.getObject("mediaValue") != null ? rs.getString("mediaValue") : "");
                bean.setContactors(AlarmConfigDao.this.getContactorsByTaskId(bean.getTaskId()));
                bean.setTitle(rs.getString("title"));
                return bean;
            }
        });
    }

    public boolean deleteWatchTask(long userId, int taskId) {
        int num = this.jdbcTemplate.update("delete from `t_alarm_rule` WHERE userId=? and taskId=? ", new Object[]{userId, taskId});
        return num == 1;
    }

    public boolean setWatchTaskStatus(long userId, int taskId, AlarmWatchInfoBean.Status status) {
        int num = this.jdbcTemplate.update("update `t_alarm_rule` set status=? WHERE userId=? and taskId=? ", new Object[]{status.intValue(), userId, taskId});
        return num == 1;
    }
}

