/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.User;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class UserDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public User getUserInfoByToken(String token) {
        List users = this.jdbcTemplate.query("SELECT * FROM t_user WHERE userToken=?", new Object[]{token}, (RowMapper)new RowMapper<User>(){

            public User mapRow(ResultSet rs, int rowNum) throws SQLException {
                User user = new User();
                user.setId(rs.getLong("userId"));
                user.setLoginName(rs.getString("loginName"));
                user.setUserToken(rs.getString("userToken"));
                user.setGroupId(rs.getString("groupId"));
                user.setGroupCode(rs.getString("groupCode"));
                user.setGroupName(rs.getString("groupName"));
                return user;
            }
        });
        return users.size() > 0 ? (User)users.get(0) : null;
    }

    public User insertUserInfo(final User userInfo) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO `t_user`(`loginName`,`userToken`, `groupId`, `groupCode`,`groupName`) VALUES(?,?,?,?,?)", 1);
                ps.setString(1, userInfo.getLoginName());
                ps.setString(2, userInfo.getUserToken());
                ps.setString(3, userInfo.getGroupId());
                ps.setString(4, userInfo.getGroupCode());
                ps.setString(5, userInfo.getGroupName());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        User user = new User();
        user.setId(keyHolder.getKey().longValue());
        return user;
    }

    public boolean updateUserInfo(User userInfo) {
        int update = this.jdbcTemplate.update("UPDATE `t_user` set `groupId`=?,`groupCode`=?,`groupName`=? WHERE `userToken`=?", new Object[]{userInfo.getGroupId(), userInfo.getGroupCode(), userInfo.getGroupName(), userInfo.getUserToken()});
        return update >= 1;
    }

    public User getUserInfoByAccount(String account) {
        List users = this.jdbcTemplate.query("SELECT * FROM t_user WHERE loginName=?", new Object[]{account}, (RowMapper)new RowMapper<User>(){

            public User mapRow(ResultSet rs, int rowNum) throws SQLException {
                User user = new User();
                user.setId(rs.getLong("userId"));
                user.setLoginName(rs.getString("loginName"));
                return user;
            }
        });
        return users.size() > 0 ? (User)users.get(0) : null;
    }

    public User getUserInfoBySiteName(String siteName) {
        List users = this.jdbcTemplate.query("SELECT * FROM t_user WHERE siteName=?", new Object[]{siteName}, (RowMapper)new RowMapper<User>(){

            public User mapRow(ResultSet rs, int rowNum) throws SQLException {
                User user = new User();
                user.setId(rs.getLong("userId"));
                user.setLoginName(rs.getString("loginName"));
                return user;
            }
        });
        return users.size() > 0 ? (User)users.get(0) : null;
    }
}

