/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.result;

import com.chinamcloud.bigdata.haiheservice.bean.Trend;
import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.bean.HotEventStatistic;
import com.chinamcloud.bigdata.haiheservice.es.result.EsResultProcessor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;

public class EsEventStatisticResultProcessor
implements EsResultProcessor<EsFeedbackQuery, SearchResponse> {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Map<String, Double> sourceMapping = new HashMap<String, Double>();

    static {
        sourceMapping.put("News", 18.44);
        sourceMapping.put("WeiboV", 0.72);
        sourceMapping.put("WeiXin", 17.76);
        sourceMapping.put("Government", 16.3);
        sourceMapping.put("Weibo", 0.72);
        sourceMapping.put("LunTan", 0.8);
        sourceMapping.put("Video", 23.8);
        sourceMapping.put("TieBa", 0.8);
        sourceMapping.put("Other", 0.5);
    }

    public HotEventStatistic processResult(EsFeedbackQuery query, SearchResponse response) {
        Aggregations aggregations = response.getAggregations();
        Histogram agg = (Histogram)aggregations.get("agg");
        HotEventStatistic statistic = new HotEventStatistic();
        ArrayList<Trend> doc_count = new ArrayList<Trend>();
        ArrayList<Trend> emotion_value = new ArrayList<Trend>();
        ArrayList<Trend> media_cover = new ArrayList<Trend>();
        ArrayList<Trend> hot_value = new ArrayList<Trend>();
        long docTotalCount = 0L;
        long emotionTotalCount = 0L;
        for (Histogram.Bucket entry : agg.getBuckets()) {
            Object key = entry.getKey();
            String keyAsString = entry.getKeyAsString();
            long docCount = entry.getDocCount();
            long time = 0L;
            try {
                time = dateFormat.parse(keyAsString).getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (docCount == 0L) {
                doc_count.add(new Trend(time, 0L));
                hot_value.add(new Trend(time, 0L));
                emotion_value.add(new Trend(time, 0L));
                media_cover.add(new Trend(time, 0L));
                continue;
            }
            doc_count.add(new Trend(time, docCount));
            Sum sum_emo = (Sum)entry.getAggregations().get("emotionscore");
            double avg_emo = sum_emo.getValue();
            emotion_value.add(new Trend(time, (long)avg_emo / docCount));
            docTotalCount += docCount;
            emotionTotalCount += (long)avg_emo;
            Cardinality media = (Cardinality)entry.getAggregations().get("tbnickname");
            long meidaValue = media.getValue();
            media_cover.add(new Trend(time, meidaValue));
            Terms terms = (Terms)entry.getAggregations().get("source");
            long hotVal = 0L;
            for (Terms.Bucket term : terms.getBuckets()) {
                Object media_type = term.getKey();
                long media_count = term.getDocCount();
                hotVal = (long)((double)hotVal + sourceMapping.getOrDefault(media_type, 0.5) * (double)media_count);
            }
            hot_value.add(new Trend(time, hotVal));
        }
        statistic.setDoc_count(doc_count);
        statistic.setEmotion_value(emotion_value);
        statistic.setHot_value(hot_value);
        statistic.setMedia_cover(media_cover);
        statistic.setDocTotalCount(docTotalCount);
        statistic.setEmotionTotalCount(emotionTotalCount);
        return statistic;
    }
}

