/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import com.chinamcloud.bigdata.haiheservice.util.JSONUtils;
import com.chinamcloud.bigdata.haiheservice.xz.SimpleParser;
import com.taobao.kelude.aps.feedback.model.ApsFeedback;
import com.taobao.kelude.aps.feedback.model.SearchResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NewsDetailParser
extends SimpleParser<HotNews, SearchResult> {
    private SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    @Override
    protected HotNews parseRecords(SearchResult result) {
        List feedbacks = result.getRecords();
        if (feedbacks.size() > 0) {
            ApsFeedback feedback = (ApsFeedback)feedbacks.get(0);
            HotNews hotNew = new HotNews();
            hotNew.setDescription(feedback.getDescription());
            hotNew.setSrc(feedback.getTbNickname());
            hotNew.setCity(feedback.getCrawlerKeywords());
            hotNew.setDocId(String.valueOf(feedback.getId()));
            hotNew.setEmotionScore(feedback.getEmotionScore());
            hotNew.setEmotionTendency(feedback.getEmotionTendency());
            hotNew.setPubTime(this.dateFormat2.format(feedback.getPubTime()));
            hotNew.setTitle(feedback.getSubject());
            hotNew.setUrl(feedback.getRefererUrl());
            hotNew.setPics(this.parsePics(feedback.getCfs()));
            hotNew.setClusterId(feedback.getClusterId());
            hotNew.setExportTime(this.dateFormat2.format(new Date()));
            return hotNew;
        }
        return null;
    }

    private List<String> parsePics(Map<String, String> cfsMap) {
        JSONArray jsonArray;
        String valueStr;
        ArrayList<String> picUrls = new ArrayList<String>();
        if (cfsMap != null && !StringUtils.isEmpty((CharSequence)(valueStr = cfsMap.get("101148"))) && (jsonArray = JSONUtils.parseJSONArray(valueStr)) != null) {
            int jsonArrayLength = jsonArray.size();
            int i = 0;
            while (i < jsonArrayLength) {
                JSONObject attachment = jsonArray.getJSONObject(i);
                String picUrl = attachment.getString("url");
                if (!StringUtils.isEmpty((CharSequence)picUrl)) {
                    picUrls.add(picUrl);
                }
                ++i;
            }
        }
        return picUrls;
    }
}

