/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.parser;

import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.AliYCAnalysisResult;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisRecord;
import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YCResultParser {
    private static Logger logger = LogManager.getLogger(YCResultParser.class);

    public AliYCAnalysisResult parserData(AnalysisRecord record, List<HotNews> hotNews) {
        long reads;
        String title;
        String source;
        Date deadline;
        AliYCAnalysisResult result = new AliYCAnalysisResult();
        Date createAt = record.getCreateAt();
        if (createAt != null) {
            result.setCreateAt(createAt);
        }
        if ((deadline = record.getDeadline()) != null) {
            result.setDeadline(deadline);
        }
        if (!StringUtils.isEmpty((CharSequence)(source = record.getSource()))) {
            result.setSource(source);
        }
        if (!StringUtils.isEmpty((CharSequence)(title = record.getScreenName()))) {
            result.setTitle(title);
        }
        if ((reads = (long)record.getReads()) != 0L) {
            result.setReads(reads);
        } else {
            result.setReads(0L);
        }
        long comments = record.getComments();
        if (comments != 0L) {
            result.setComments(comments);
        } else {
            result.setComments(0L);
        }
        long thumbs = record.getThumbs();
        if (comments != 0L) {
            result.setThumbs(thumbs);
        } else {
            result.setThumbs(0L);
        }
        String url = result.getUrl();
        if (!StringUtils.isEmpty((CharSequence)url)) {
            result.setUrl(url);
        }
        HashSet<HotNews> megreResult = new HashSet<HotNews>(hotNews);
        ArrayList<HotNews> processResult = new ArrayList<HotNews>();
        processResult.addAll(megreResult);
        JSONObject object = new JSONObject();
        Set<String> forwardMedia = this.parserForwardMedia(processResult);
        object.put("forwardMedia", forwardMedia);
        List<ForwardInfo> forwardMediaMap = this.parserForwardMediaMap(processResult);
        object.put("forwardMediaMap", forwardMediaMap);
        List<ForwardInfo> forwardMediaList = this.parserForwardMediaList(processResult);
        object.put("forwardMediaList", forwardMediaList);
        object.put("forwards", (Object)forwardMediaList.size());
        result.setData(object);
        String outline = createAt + "," + source + "\u7f51\u53d1\u8868\u6807\u9898\u4e3a" + title + "\u7684\uff08\u62a5\u9053\u3001\u6587\u7ae0\uff09,\u622a\u6b62" + deadline + ", \u5171\u8ba1\u9605\u8bfb" + reads + "\u6b21, \u8bc4\u8bba" + comments + "\u6761, \u70b9\u8d5e" + thumbs + "\u6b21,";
        if (forwardMediaList.size() == 0) {
            outline = String.valueOf(outline) + "\u65e0\u7591\u4f3c\u8f6c\u8f7d\u3002";
        } else {
            result.setForwards(forwardMediaList.size());
            outline = String.valueOf(outline) + "\u7591\u4f3c\u8f6c\u8f7d" + forwardMediaList.size() + "\u6b21\u3002";
            logger.info("forwardMedia.size()=" + forwardMedia.size());
            if (forwardMedia.size() <= 10) {
                outline = String.valueOf(outline) + "\u671f\u95f4\u7591\u4f3c\u88ab " + String.join((CharSequence)",", forwardMedia) + " \u7b49\u8f6c\u8f7d\u3002";
            } else {
                LinkedHashSet<String> tmp = new LinkedHashSet<String>();
                Iterator<String> iterator = forwardMedia.iterator();
                int i = 0;
                while (i < 10) {
                    String media = iterator.next();
                    tmp.add(media);
                    ++i;
                }
                logger.info("tmp" + ((Object)tmp).toString());
                logger.info(String.join((CharSequence)",", tmp));
                outline = String.valueOf(outline) + "\u671f\u95f4\u7591\u4f3c\u88ab" + String.join((CharSequence)",", tmp) + "\u7b49\u8f6c\u8f7d\u3002";
            }
        }
        result.setOutline(outline);
        return result;
    }

    private Set<String> parserForwardMedia(List<HotNews> records) {
        LinkedHashSet<String> mediaSetting = new LinkedHashSet<String>();
        if (records != null && records.size() > 0) {
            records.forEach(x -> {
                String parentSource = x.getParentSource();
                mediaSetting.add(parentSource);
            });
        }
        return mediaSetting;
    }

    private List<ForwardInfo> parserForwardMediaMap(List<HotNews> records) {
        ArrayList<ForwardInfo> infoList = new ArrayList<ForwardInfo>();
        if (records != null && records.size() > 0) {
            records.forEach(x -> {
                String parentSource = x.getParentSource();
                String pubTime = x.getPubTime();
                Integer emotionTendency = x.getEmotionTendency();
                Integer emotionScore = x.getEmotionScore();
                infoList.add(new ForwardInfo(parentSource, pubTime, emotionScore, emotionTendency));
            });
        }
        return infoList;
    }

    private List<ForwardInfo> parserForwardMediaList(List<HotNews> records) {
        ArrayList<ForwardInfo> infoList = new ArrayList<ForwardInfo>();
        if (records != null && records.size() > 0) {
            records.forEach(x -> {
                String description = x.getDescription();
                String parentSource = x.getParentSource();
                String cluster = x.getCluster();
                String pubTime = x.getPubTime();
                String url = x.getUrl();
                infoList.add(new ForwardInfo(cluster, description, pubTime, parentSource, url));
            });
        }
        return infoList;
    }

    class ForwardInfo {
        private String cluster;
        private String description;
        private String parentSource;
        private String pubTime;
        private Integer emotionScore;
        private Integer emotionTendency;
        private String url;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Integer getEmotionScore() {
            return this.emotionScore;
        }

        public void setEmotionScore(Integer emotionScore) {
            this.emotionScore = emotionScore;
        }

        public Integer getEmotionTendency() {
            return this.emotionTendency;
        }

        public void setEmotionTendency(Integer emotionTendency) {
            this.emotionTendency = emotionTendency;
        }

        public ForwardInfo() {
        }

        public ForwardInfo(String parentSource, String pubTime, Integer emotionScore, Integer emotionTendency) {
            this.parentSource = parentSource;
            this.pubTime = pubTime;
            this.emotionScore = emotionScore;
            this.emotionTendency = emotionTendency;
        }

        public ForwardInfo(String cluster, String description, String pubTime, String parentSource, String url) {
            this.description = description;
            this.parentSource = parentSource;
            this.cluster = cluster;
            this.pubTime = pubTime;
            this.url = url;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getParentSource() {
            return this.parentSource;
        }

        public void setParentSource(String parentSource) {
            this.parentSource = parentSource;
        }

        public String getCluster() {
            return this.cluster;
        }

        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public String getPubTime() {
            return this.pubTime;
        }

        public void setPubTime(String pubTime) {
            this.pubTime = pubTime;
        }
    }
}

