/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.service;

import com.chinamcloud.bigdata.haiheservice.bean.HotTopic;
import com.chinamcloud.bigdata.haiheservice.util.DateUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.ValidationResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class CalcTopicHotService {
    private static Logger logger = LogManager.getLogger(CalcTopicHotService.class);
    private static Set<String> variableNames = new HashSet<String>();

    static {
        variableNames.add("A");
        variableNames.add("B");
        variableNames.add("C");
        variableNames.add("D");
    }

    public boolean calcTopicHotValue(String formula, List<HotTopic> hotTopic) {
        Expression e;
        block3: {
            try {
                e = new ExpressionBuilder(formula).variables(variableNames).build();
                ValidationResult validate = e.validate(false);
                if (validate.isValid()) break block3;
                return false;
            }
            catch (Exception e2) {
                logger.error("\u8ba1\u7b97\u70ed\u5ea6\u7684\u516c\u5f0f\u9519\u8bef");
                return false;
            }
        }
        hotTopic.forEach(x -> {
            HashMap<String, Double> variables = new HashMap<String, Double>();
            double emotionScore = x.getEmotionScore().longValue();
            double mediaCover = x.getMediaCover().longValue();
            double docValue = x.getDocValue().longValue();
            double pubTimeInterval = DateUtils.computeTimeinterval(x.getPubTime(), x.getPubTimeEnd());
            variables.put("A", emotionScore);
            variables.put("B", mediaCover);
            variables.put("C", docValue);
            variables.put("D", pubTimeInterval);
            e.setVariables(variables);
            double hotValue = e.evaluate();
            x.setHotValue(Math.round(hotValue));
        });
        Collections.sort(hotTopic, (h1, h2) -> h2.getHotValue().compareTo(h1.getHotValue()));
        return true;
    }
}

