/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.service;

import com.chinamcloud.bigdata.haiheservice.bean.KeyWords;
import com.chinamcloud.bigdata.haiheservice.bean.MonitorTopic;
import com.chinamcloud.bigdata.haiheservice.bean.Quota;
import com.chinamcloud.bigdata.haiheservice.bean.TopicIndex;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.dao.MonitorTopicDao;
import com.chinamcloud.bigdata.haiheservice.pojo.AliKeywordsAddParams;
import com.chinamcloud.bigdata.haiheservice.service.AliDataService;
import com.chinamcloud.bigdata.haiheservice.service.CMCService;
import com.chinamcloud.bigdata.haiheservice.util.AliSearchKeyConf;
import com.chinamcloud.bigdata.haiheservice.util.AliSearchKeyRuleUtils;
import com.taobao.kelude.aps.crawler.model.MonitorKeyword;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MonitorTopicService {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private MonitorTopicDao dao;
    @Autowired
    private AliDataService aliService;
    @Autowired
    private CMCService cmcService;

    @Transactional(rollbackFor={Exception.class})
    public void saveUserDefineTopic(MonitorTopic topic) {
        List<KeyWords> keywords;
        this.dao.saveUserDefineTopic(topic);
        Integer status = topic.getIncludeSearch();
        if (status != null && status == 1 && (keywords = topic.getKeyWords()) != null && keywords.size() > 0) {
            AliSearchKeyConf conf = AliSearchKeyConf.getConf();
            List<MonitorKeyword> aliKeywords = keywords.stream().filter(x -> AliSearchKeyRuleUtils.matchRule(x.getKeyWord())).map(x -> {
                Object[] arrays = x.getKeyWord().split(" ");
                Arrays.sort(arrays);
                MonitorKeyword keyword = new MonitorKeyword();
                keyword.setKeyword(StringUtils.join((Object[])arrays, (String)" "));
                keyword.setProductId(conf.getProductId());
                keyword.setTopicId(conf.getTopicId());
                keyword.setKeywordFlag(Integer.valueOf(0));
                return keyword;
            }).collect(Collectors.toList());
            AliKeywordsAddParams params = new AliKeywordsAddParams();
            params.setKeywords(aliKeywords);
            params.setSpiderTopicId(conf.getSpiderTopicId());
            this.aliService.addMonitorKeyword(params);
        }
    }

    public void delUserDefineTopic(Long id, Long userId) {
        this.dao.delUserDefineTopic(id, userId);
    }

    public MonitorTopic selectDefineTopic(Long topicId) {
        return this.dao.selectDefineTopic(topicId);
    }

    public List<MonitorTopic> selectUserSubDefineTopics(Long userId) {
        return this.dao.selectUserSubDefineTopics(userId);
    }

    public MonitorTopic selectUserSubDefineTopic(Long userId, Long topicId) {
        return this.dao.selectUserSubDefineTopic(userId, topicId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveTopicIndex(TopicIndex topicIndex) {
        this.dao.saveTopicIndex(topicIndex);
    }

    public void updateTopicIndexTime(Long topicId) {
        this.dao.updateTopicIndexTime(topicId);
    }

    public List<MonitorTopic> selectDefineHotTopics(long userId, int size) {
        return this.dao.selectDefineHotTopics(userId, size);
    }

    public List<MonitorTopic> selectDefineTopics() {
        return this.dao.selectDefineTopics();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDefineTopic(MonitorTopic topic) {
        this.dao.updateDefineTopic(topic);
        Integer status = topic.getIncludeSearch();
        if (status != null && status == 1) {
            List<KeyWords> keywords = topic.getKeyWords();
            if (keywords == null) {
                keywords = this.dao.selectTopicKeywords(topic.getId());
            }
            if (keywords != null && keywords.size() > 0) {
                AliSearchKeyConf conf = AliSearchKeyConf.getConf();
                List<MonitorKeyword> aliKeywords = keywords.stream().filter(x -> AliSearchKeyRuleUtils.matchRule(x.getKeyWord())).map(x -> {
                    Object[] arrays = x.getKeyWord().split(" ");
                    Arrays.sort(arrays);
                    MonitorKeyword keyword = new MonitorKeyword();
                    keyword.setKeyword(StringUtils.join((Object[])arrays, (String)" "));
                    keyword.setProductId(conf.getProductId());
                    keyword.setTopicId(conf.getTopicId());
                    keyword.setKeywordFlag(Integer.valueOf(0));
                    return keyword;
                }).collect(Collectors.toList());
                AliKeywordsAddParams params = new AliKeywordsAddParams();
                params.setKeywords(aliKeywords);
                params.setSpiderTopicId(conf.getSpiderTopicId());
                this.aliService.addMonitorKeyword(params);
            }
        }
    }

    public void subDefineTopic(Long userId, Long topicId) {
        this.dao.subDefineTopic(userId, topicId, 600);
    }

    public boolean checkQuoat(User user, int topicCount, int keywordCount) {
        if (keywordCount == 0) {
            return true;
        }
        User userInfo = this.cmcService.getCmcUserInfo(user.getUserToken());
        Quota topicQuato = userInfo.getTopicQuato();
        Quota keywordQuato = userInfo.getKeywordQuato();
        if (topicQuato != null && keywordQuato != null) {
            String rest_qota = topicQuato.getRest_qota();
            String rest_qota2 = keywordQuato.getRest_qota();
            if (rest_qota != null && rest_qota2 != null) {
                int rest_topic = Integer.valueOf(rest_qota);
                int rest_keyword = Integer.valueOf(rest_qota2);
                return rest_topic >= topicCount && rest_keyword >= keywordCount;
            }
        }
        return false;
    }

    public boolean reportQuoat(User user, int topicQuota, int keywordQuota) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("user_token", user.getUserToken());
        queryParams.put("report_time", this.format.format(new Date()));
        ArrayList report_data = new ArrayList();
        if (topicQuota != 0) {
            HashMap<String, String> topic = new HashMap<String, String>();
            topic.put("item_code", "topic");
            topic.put("report_type", "1");
            topic.put("qota_value", String.valueOf(topicQuota));
            report_data.add(topic);
        }
        if (keywordQuota != 0) {
            HashMap<String, String> keyword = new HashMap<String, String>();
            keyword.put("item_code", "keyword");
            keyword.put("report_type", "1");
            keyword.put("qota_value", String.valueOf(keywordQuota));
            report_data.add(keyword);
        }
        if (report_data.size() > 0) {
            queryParams.put("report_data", report_data);
            return this.cmcService.reportQuoat(user.getUserToken(), queryParams);
        }
        return false;
    }
}

