/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.service;

import com.alibaba.druid.util.StringUtils;
import com.chinamcloud.bigdata.haiheservice.bean.CustomCloumnBean;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import com.chinamcloud.bigdata.haiheservice.bean.SiteConfig;
import com.chinamcloud.bigdata.haiheservice.bean.SiteStatistic;
import com.chinamcloud.bigdata.haiheservice.dao.SiteStatisticDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiteStatisticService {
    @Autowired
    private SiteStatisticDao dao;

    public List<SiteStatistic> findSitesByUserId(Long userId) {
        return this.dao.findSitesByUserId(userId);
    }

    public List<SiteStatistic> findStatisticList() {
        return this.dao.findStatisticListByUserIds(new Long[0]);
    }

    public List<SiteStatistic> findStatisticListByUserIds(Long ... userId) {
        return this.dao.findStatisticListByUserIds(userId);
    }

    public List<SiteStatistic> findStatisticList(Long userId, int catId) {
        return this.dao.findStatisticList(userId, catId);
    }

    public boolean updateStatistic(SiteStatistic siteStatistic) {
        return this.dao.updateStatistic(siteStatistic);
    }

    public boolean updateStatistic(List<SiteStatistic> siteStatistic) {
        return this.dao.updateStatistic(siteStatistic);
    }

    public List<SiteStatistic> findSourceIdListByUserId(String provinceId) {
        return this.dao.findSourceIdListByUserId(provinceId);
    }

    public SiteConfig findSiteStatus(long userId) {
        SiteConfig siteStaus = this.dao.findSiteStatus(userId);
        if (siteStaus == null) {
            siteStaus = new SiteConfig();
            siteStaus.setWangzhanVisible("ON");
            siteStaus.setWeiboVisible("ON");
            siteStaus.setWeixinVisible("ON");
        }
        return siteStaus;
    }

    public List<FacetResult> findSiteCount(long userId) {
        List<FacetResult> siteCounts = this.dao.findSiteCount(userId);
        SiteConfig siteStatus = this.dao.findSiteStatus(userId);
        return siteCounts.stream().filter(x -> {
            String name = x.getName();
            if (siteStatus != null) {
                if (name.equals("1") && siteStatus.getWangzhanVisible().equals("ON")) {
                    return true;
                }
                if (name.equals("2") && siteStatus.getWeiboVisible().equals("ON")) {
                    return true;
                }
                if (name.equals("3") && siteStatus.getWeixinVisible().equals("ON")) {
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
    }

    public Map<String, List<SiteStatistic>> findSitesWithConfig(Long userId, int catId, String flag) {
        List<SiteStatistic> sites = this.dao.findStatisticList(userId, catId);
        List<Object> sites_has_no_keysourceIds = new ArrayList();
        ArrayList<SiteStatistic> keySourceIds = new ArrayList<SiteStatistic>();
        Map<Integer, String> sitesInfo = sites.stream().collect(Collectors.toMap(SiteStatistic::getSourceId, SiteStatistic::getName));
        SiteConfig siteConfig = this.dao.findSiteConfig(userId);
        String[] tmpKeySourceIds = null;
        if (siteConfig != null) {
            switch (catId) {
                case 1: {
                    String wangzhanSourcesIds = siteConfig.getWangzhanSourcesIds();
                    if (StringUtils.isEmpty((String)wangzhanSourcesIds)) break;
                    tmpKeySourceIds = wangzhanSourcesIds.split(",");
                    break;
                }
                case 2: {
                    String weiboSourcesIds = siteConfig.getWeiboSourcesIds();
                    if (StringUtils.isEmpty((String)weiboSourcesIds)) break;
                    tmpKeySourceIds = weiboSourcesIds.split(",");
                    break;
                }
                case 3: {
                    String weixinSourcesIds = siteConfig.getWeixinSourcesIds();
                    if (StringUtils.isEmpty((String)weixinSourcesIds)) break;
                    tmpKeySourceIds = weixinSourcesIds.split(",");
                }
            }
            if (tmpKeySourceIds != null) {
                String[] stringArray = tmpKeySourceIds;
                int n = tmpKeySourceIds.length;
                int weiboSourcesIds = 0;
                while (weiboSourcesIds < n) {
                    String tmpKeySourceId = stringArray[weiboSourcesIds];
                    SiteStatistic bean = new SiteStatistic();
                    Integer sourceId = Integer.valueOf(tmpKeySourceId);
                    bean.setSourceId(sourceId);
                    bean.setName(sitesInfo.getOrDefault(sourceId, "\u9519\u8bef"));
                    keySourceIds.add(bean);
                    ++weiboSourcesIds;
                }
            }
        }
        HashMap<String, List<SiteStatistic>> result = new HashMap<String, List<SiteStatistic>>();
        if (flag.equals("true")) {
            List tmp = Arrays.asList(tmpKeySourceIds);
            sites_has_no_keysourceIds = sites.stream().filter(x -> !tmp.contains(String.valueOf(x.getSourceId()))).collect(Collectors.toList());
            result.put("allSourceIds", sites_has_no_keysourceIds);
        } else {
            result.put("allSourceIds", sites);
        }
        result.put("keySourceIds", keySourceIds);
        return result;
    }

    public boolean saveSiteConfig(long userId, SiteConfig conf) {
        Pattern p = Pattern.compile("[\\d,]*+");
        StringBuilder builder = new StringBuilder();
        String wzSourcesIds = conf.getWangzhanSourcesIds();
        String wbSourcesIds = conf.getWeiboSourcesIds();
        String wxSourceIds = conf.getWeixinSourcesIds();
        if (p.matcher(wzSourcesIds).matches() && p.matcher(wbSourcesIds).matches() && p.matcher(wxSourceIds).matches()) {
            if (!StringUtils.isEmpty((String)wzSourcesIds)) {
                builder.append(String.valueOf(wzSourcesIds) + ",");
            }
            if (!StringUtils.isEmpty((String)wbSourcesIds)) {
                builder.append(String.valueOf(wbSourcesIds) + ",");
            }
            if (!StringUtils.isEmpty((String)wxSourceIds)) {
                builder.append(wxSourceIds);
            }
        } else {
            return false;
        }
        return this.dao.saveSiteConfig(conf, userId);
    }

    public List<CustomCloumnBean> getColumnsByCatId(long userId, int catId) {
        return this.dao.getColumnsByCatId(userId, catId);
    }

    public List<String> findSitesByColumns(Long userId, int catId, String column) {
        List<String> list = this.dao.getSitesByColumns(userId, catId, column);
        if (list != null && list.size() >= 1) {
            String tmp = list.get(0);
            String[] split = tmp.split(",");
            return Arrays.asList(split);
        }
        return null;
    }

    public boolean saveColumn(Long userId, int catId, String column, String sourceIds) {
        return this.dao.saveColumn(userId, catId, column, sourceIds);
    }

    public boolean updateColumn(Long userId, String column, String sourceIds, String cloumnId) {
        return this.dao.updateColumn(userId, column, sourceIds, cloumnId);
    }

    public boolean deleteColumn(Long userId, String columnId) {
        return this.dao.deleteColumn(userId, columnId);
    }
}

