/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

public class AliSearchKeyRuleUtils {
    private static final String RULE_PATTERN = "[\u4e00-\u9fa5\\w\\s]+";

    public static boolean matchRule(String str) {
        if (!str.matches(RULE_PATTERN)) {
            return false;
        }
        String[] array = str.split(" ");
        boolean check = true;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String temp = stringArray[n2];
            int i = temp.length();
            int chineseCount = 0;
            int engCount = 0;
            int numberCount = 0;
            WordType type = null;
            while (i > 0) {
                type = AliSearchKeyRuleUtils.getWordType(temp.charAt(--i));
                switch (type) {
                    case CHINESE: {
                        ++chineseCount;
                        break;
                    }
                    case ENG: {
                        ++engCount;
                        break;
                    }
                    case NUMBER: {
                        ++numberCount;
                        break;
                    }
                }
            }
            int totalWord = chineseCount + numberCount + engCount;
            if (chineseCount <= 2 && (totalWord < 4 || numberCount >= totalWord)) {
                check = false;
                break;
            }
            ++n2;
        }
        return check;
    }

    private static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isEng(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static WordType getWordType(char c) {
        if (AliSearchKeyRuleUtils.isChinese(c)) {
            return WordType.CHINESE;
        }
        if (AliSearchKeyRuleUtils.isEng(c)) {
            return WordType.ENG;
        }
        if (AliSearchKeyRuleUtils.isNumber(c)) {
            return WordType.NUMBER;
        }
        return WordType.FORBIDDEN;
    }

    private static enum WordType {
        ENG,
        CHINESE,
        NUMBER,
        FORBIDDEN;

    }
}

