/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtils {
    private static Logger logger = LogManager.getLogger(HttpUtils.class);

    public static HttpRequestResult executePost(String url, String queryParams) {
        HttpRequestResult requestResult;
        block14: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = null;
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(queryParams, "UTF-8");
            entity.setContentType("text/json");
            httpPost.setEntity((HttpEntity)entity);
            requestResult = null;
            try {
                try {
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    if (response != null && response.getStatusLine().getStatusCode() == 200) {
                        HttpEntity entity2 = response.getEntity();
                        String result = EntityUtils.toString((HttpEntity)entity2);
                        EntityUtils.consume((HttpEntity)entity2);
                        requestResult = new HttpRequestResult(Status.SUCCESS);
                        requestResult.setMsg(result);
                        break block14;
                    }
                    logger.error("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url=" + url);
                    requestResult = new HttpRequestResult(Status.FALILD);
                    requestResult.setMsg("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url=" + url);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    requestResult = new HttpRequestResult(Status.FALILD);
                    requestResult.setMsg(e.getLocalizedMessage());
                    try {
                        if (response != null) {
                            response.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return requestResult;
    }

    public static HttpRequestResult executeGet(String url, Header[] headers) {
        HttpRequestResult requestResult;
        block15: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = null;
            HttpGet httpGet = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
            httpGet.setConfig(requestConfig);
            httpGet.addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
            httpGet.addHeader("Connection", "Keep-Alive");
            httpGet.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:29.0) Gecko/20100101 Firefox/29.0");
            httpGet.addHeader("Cookie", "");
            if (headers != null && headers.length > 0) {
                httpGet.setHeaders(headers);
            }
            requestResult = null;
            try {
                try {
                    response = httpClient.execute((HttpUriRequest)httpGet);
                    if (response != null && response.getStatusLine().getStatusCode() == 200) {
                        HttpEntity entity = response.getEntity();
                        String result = EntityUtils.toString((HttpEntity)entity);
                        EntityUtils.consume((HttpEntity)entity);
                        requestResult = new HttpRequestResult(Status.SUCCESS);
                        requestResult.setMsg(result);
                        break block15;
                    }
                    logger.error("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url = " + url);
                    requestResult = new HttpRequestResult(Status.FALILD);
                    requestResult.setMsg("http\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6570\u636e\u8fd4\u56de,url=" + url);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    requestResult = new HttpRequestResult(Status.FALILD);
                    requestResult.setMsg(e.getLocalizedMessage());
                    try {
                        if (response != null) {
                            response.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return requestResult;
    }

    public static HttpRequestResult executeGet(String url, String queryParams, Header[] headers) {
        JSONObject params = JSON.parseObject((String)queryParams);
        if (params != null && !params.isEmpty()) {
            for (Map.Entry param : params.entrySet()) {
                url = String.valueOf(url) + "&" + (String)param.getKey() + "=" + param.getValue();
            }
        }
        return HttpUtils.executeGet(url, headers);
    }

    public static class HttpRequestResult {
        private final Status status;
        private String msg;

        public Status getStatus() {
            return this.status;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public HttpRequestResult(Status status) {
            this.status = status;
        }
    }

    public static enum Status {
        SUCCESS,
        FALILD;

    }
}

