/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import com.chinamcloud.bigdata.haiheservice.bean.KeyWords;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TopicKeywordUtils {
    public static final List<KeyWords> parseTopicKeyWords(List<String> keywords) {
        return keywords.stream().filter(x -> x.trim().length() > 0).map(x -> {
            KeyWords words = new KeyWords();
            words.setKeyWord(x.trim().replaceAll("\\s{2}", " "));
            return words;
        }).collect(Collectors.toList());
    }

    public static final String buildQueryByStr(List<String> keyWords) {
        if (keyWords.size() > 0) {
            List list = keyWords.stream().map(x -> x.replaceAll("\\s", " AND ")).collect(Collectors.toList());
            return StringUtils.join(list, (String)" OR ");
        }
        return "";
    }

    public static final String buildQueryByStr(String keywords) {
        return keywords.replace(" ", "AND").replaceAll(",", "OR");
    }

    public static final String buildQueryByObject(List<KeyWords> keyWords) {
        if (keyWords.size() > 0) {
            List list = keyWords.stream().map(x -> x.getKeyWord().replaceAll("\\s", " AND ")).collect(Collectors.toList());
            return StringUtils.join(list, (String)" OR ");
        }
        return "";
    }

    public static final String appendQuery(String str, String str2, boolean add) {
        return String.valueOf(str) + " " + (add ? " AND " : " OR ") + " " + str2;
    }

    public static int clcTopicKeyWords(List<String> keywords) {
        int count = 0;
        for (String keyword : keywords) {
            if (!StringUtils.isNotBlank((CharSequence)keyword)) continue;
            count += keyword.split(" ").length;
        }
        return count;
    }
}

