/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.xz;

import com.chinamcloud.bigdata.haiheservice.util.ConfigureUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AliDataFilterManager {
    private static Logger logger = LogManager.getLogger(AliDataFilterManager.class);
    private static AliDataFilterManager manager = new AliDataFilterManager();
    private List<String> contentFilterStrList = new ArrayList<String>();
    private List<String> districtFilterStrList = new ArrayList<String>();

    public static AliDataFilterManager getInstance() {
        return manager;
    }

    public static synchronized void init() {
        manager.initFilter();
    }

    private AliDataFilterManager() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> fileReader(String filePath) {
        File file;
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)filePath) || !(file = new File(filePath)).exists()) return list;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileReader reader = new FileReader(file);
                try {
                    try (BufferedReader bufferedReader = new BufferedReader(reader);){
                        String temp = null;
                        while ((temp = bufferedReader.readLine()) != null) {
                            list.add(temp);
                        }
                    }
                    if (reader == null) return list;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return list;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("fileReader error", (Throwable)e);
        }
        return list;
    }

    public List<String> getContentFilterStrList() {
        return this.contentFilterStrList;
    }

    public List<String> getDistrictFilterStrList() {
        return this.districtFilterStrList;
    }

    private void initContentFilter() {
        this.contentFilterStrList.addAll(this.fileReader(String.valueOf(ConfigureUtils.class.getResource("/").getPath()) + File.separator + "config" + File.separator + "contentfilter.txt"));
        logger.info("loaded contentfilter.txt size=" + this.contentFilterStrList.size());
    }

    private void initDistrictfilter() {
        this.districtFilterStrList.addAll(this.fileReader(String.valueOf(ConfigureUtils.class.getResource("/").getPath()) + File.separator + "config" + File.separator + "districtfilter.txt"));
        logger.info("loaded districtfilter.txt size=" + this.districtFilterStrList.size());
    }

    private void initFilter() {
        this.initContentFilter();
        this.initDistrictfilter();
    }
}

