/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice;

import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CodeResult {
    private int code;
    private String msg;
    private Object result;

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public CodeResult(Code code, Object result) {
        this.code = code.getCodeValue();
        this.result = result;
    }

    public CodeResult(Code code, Object result, String msg) {
        this.code = code.getCodeValue();
        this.result = result;
        this.msg = msg;
    }

    public CodeResult(Code code, String msg) {
        this.code = code.getCodeValue();
        this.msg = msg;
    }

    public CodeResult(Code code) {
        this.code = code.getCodeValue();
    }

    public static CodeResult failedResult(String msg) {
        return new CodeResult(Code.Failed, msg);
    }

    public static CodeResult failedResultByMsgSource(String source) {
        return CodeResult.failedResult(MessageSource.getMsg(source));
    }

    public static CodeResult successResult(String msg, Object result) {
        return new CodeResult(Code.Success, result, msg);
    }

    public static CodeResult successResultByMsgSource(String source, Object result) {
        return new CodeResult(Code.Success, null, MessageSource.getMsg(source));
    }

    public static CodeResult successResult() {
        return CodeResult.successResult(null, null);
    }

    public static enum Code {
        Success(0),
        Failed(1),
        Invalid(1000),
        SuccessWithWarnning(-1),
        LoginTimeOut(2),
        AnalysisRunning(-2);

        private int code;

        private Code(int code) {
            this.code = code;
        }

        public int getCodeValue() {
            return this.code;
        }
    }
}

