/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice;

import com.chinamcloud.bigdata.haiheservice.IFeedbackQueryProcessor;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.util.DateUtils;
import com.taobao.kelude.aps.feedback.model.FeedbackQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParamsFeedBackQueryProcessor
implements IFeedbackQueryProcessor {
    private static Map<String, String> sortFieldsMaping = new HashMap<String, String>();
    private static Map<String, String> facetFieldMapping;
    private static Logger logger;
    private FeedbackQuery feedbackQuery;
    private HotParams params;

    static {
        sortFieldsMaping.put("pubTime", "pub_time");
        sortFieldsMaping.put("points_count", "points_count");
        sortFieldsMaping.put("emotionScore", "emotion_score");
        sortFieldsMaping.put("createdAt", "created_at");
        facetFieldMapping = new HashMap<String, String>();
        facetFieldMapping.put("monitor_topic_id", "monitor_topic_id");
        facetFieldMapping.put("crawler_keywords", "crawler_keywords");
        facetFieldMapping.put("emotion_tendency", "emotion_tendency");
        facetFieldMapping.put("emotion_tendency_site", "emotion_tendency");
        facetFieldMapping.put("emotion_tendency_topic", "emotion_tendency");
        facetFieldMapping.put("emotion_tendency_predict", "emotion_tendency");
        facetFieldMapping.put("parent_source", "parent_source");
        facetFieldMapping.put("tb_nickname", "tb_nickname");
        facetFieldMapping.put("summary_keywords", "summary_keywords");
        facetFieldMapping.put("pubTime", "pub_time");
        facetFieldMapping.put("source_id", "source_id");
        logger = LogManager.getLogger(ParamsFeedBackQueryProcessor.class);
    }

    public ParamsFeedBackQueryProcessor(HotParams params) {
        this.params = params;
    }

    protected void setParams() {
        this.setDt().setPageIndex().setPageSize().setSortFields().setFacetFields().setEmotionTendency().setSummaryKeyWords().setClusterId().setContent().setSourceIds().setCluster().setSpiderTopicIds().setClusteFlag().setMonitorTopicId().setCrawlerKeywords().setWordCut().setProductIds().setDocId().setTbNickName();
    }

    protected ParamsFeedBackQueryProcessor setDt() {
        String day;
        Date fromDt = this.params.getFromDt();
        Date toDt = this.params.getToDt();
        if (fromDt == null && toDt == null && !StringUtils.isEmpty((CharSequence)(day = this.params.getDay()))) {
            Date[] dates = null;
            try {
                dates = DateUtils.computeDatesBackward(Integer.valueOf(day), false);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
            fromDt = dates[0];
            toDt = dates[1];
        }
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        if (!DateUtils.isDateAfter(fromDt, toDt)) {
            throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
        }
        if (fromDt != null) {
            this.feedbackQuery.setPubTimeBegin(fastDateFormat.format(fromDt));
        }
        if (toDt != null) {
            this.feedbackQuery.setPubTimeEnd(fastDateFormat.format(toDt));
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setPageIndex() {
        this.feedbackQuery.setPageIndex(this.params.getPage());
        return this;
    }

    protected ParamsFeedBackQueryProcessor setPageSize() {
        int size = Math.min(500, this.params.getSize());
        this.feedbackQuery.setPageSize(Integer.valueOf(size));
        return this;
    }

    protected ParamsFeedBackQueryProcessor setSortFields() {
        List<String> sortFields = this.params.getSortFields();
        ArrayList<String> sortMethod = new ArrayList<String>();
        if (sortFields != null && sortFields.size() > 0) {
            for (String field : sortFields) {
                String[] splitFields = field.split(" ");
                String fieldName = "";
                String sortType = "";
                if (splitFields.length > 0 && (fieldName = sortFieldsMaping.get(splitFields[0].trim())) == null) {
                    throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
                }
                if (splitFields.length > 1 && !"desc".equals(sortType = splitFields[1].trim().toLowerCase()) && !"asc".equals(sortType)) {
                    throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
                }
                if (sortType.length() > 0) {
                    sortMethod.add(String.valueOf(fieldName) + " " + sortType);
                    continue;
                }
                sortMethod.add(fieldName);
            }
        } else {
            sortMethod.add("points_count desc");
        }
        this.feedbackQuery.setSortingMethods(sortMethod);
        return this;
    }

    protected ParamsFeedBackQueryProcessor setEmotionTendency() {
        String emotionTendency = this.params.getEmotionTendency();
        if (!StringUtils.isEmpty((CharSequence)emotionTendency)) {
            this.feedbackQuery.setEmotionTendency(Integer.valueOf(emotionTendency));
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setSummaryKeyWords() {
        List<String> summaryKeyWords = this.params.getSummaryKeywordList();
        if (summaryKeyWords != null && summaryKeyWords.size() > 0) {
            this.feedbackQuery.setSummaryKeywords(summaryKeyWords);
            this.feedbackQuery.setDescription(summaryKeyWords.toArray()[0].toString());
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setClusterId() {
        if (!StringUtils.isEmpty((CharSequence)this.params.getClusterId())) {
            try {
                this.feedbackQuery.setClusterId(Long.valueOf(this.params.getClusterId()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setContent() {
        if (!StringUtils.isEmpty((CharSequence)this.params.getContent())) {
            this.feedbackQuery.setDescription(this.params.getContent());
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setCluster() {
        if (!StringUtils.isEmpty((CharSequence)this.params.getCluster())) {
            this.feedbackQuery.setCluster(this.params.getCluster());
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setClusteFlag() {
        Integer clusterFlag = this.params.getClusterFlag();
        if (clusterFlag != null) {
            this.feedbackQuery.setClusterFlag(clusterFlag);
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setFacetFields() {
        if (!StringUtils.isEmpty((CharSequence)this.params.getFacetField())) {
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(facetFieldMapping.get(this.params.getFacetField()));
            this.feedbackQuery.setFacetFields(fields);
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setSourceIds() {
        List<String> sourceIds = this.params.getSourceIds();
        if (sourceIds != null) {
            try {
                this.feedbackQuery.setSourceIds(sourceIds.stream().map(x -> Integer.valueOf(x)).collect(Collectors.toList()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setCrawlerKeywords() {
        List<String> getCrawlerKeywords = this.params.getCrawlerKeywords();
        if (getCrawlerKeywords != null) {
            this.feedbackQuery.setCrawlerKeywords(getCrawlerKeywords.get(0));
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setSpiderTopicIds() {
        List<Integer> spiderTopicIds = this.params.getSpiderTopicIds();
        if (spiderTopicIds != null) {
            this.feedbackQuery.setSpiderTopicIds(spiderTopicIds);
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setMonitorTopicId() {
        Integer monitorTopicId = this.params.getMonitorTopicId();
        if (monitorTopicId != null) {
            this.feedbackQuery.setMonitorTopicId(monitorTopicId);
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setWordCut() {
        if (this.params.getWordCut() != null) {
            this.feedbackQuery.setWordCut(this.params.getWordCut());
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setProductIds() {
        List<Integer> produceIds = this.params.getProduceIds();
        if (produceIds != null && produceIds.size() > 0) {
            this.feedbackQuery.setProductIds(produceIds);
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setDocId() {
        String docId = this.params.getId();
        if (docId != null) {
            this.feedbackQuery.setId(Long.valueOf(docId));
        }
        return this;
    }

    protected ParamsFeedBackQueryProcessor setTbNickName() {
        List<String> tbNicknames = this.params.getTbNickNames();
        if (tbNicknames != null && tbNicknames.size() > 0) {
            this.feedbackQuery.setTbNicknames(tbNicknames);
        }
        return this;
    }

    @Override
    public void process(FeedbackQuery query) {
        this.feedbackQuery = query;
        this.setParams();
    }

    public class ConfigMappingNoDataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ConfigMappingNoDataException(String message) {
            super(message);
        }
    }
}

