/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.afterprocessor;

import com.chinamcloud.bigdata.haiheservice.afterprocessor.IAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NewsEmotionTendencyAfterProcessor
implements IAfterProcessor<List<FacetResult>> {
    private static Map<String, String> emotionMaps = new HashMap<String, String>();

    static {
        emotionMaps.put("-1", "\u4e2d\u7acb\u8206\u60c5");
        emotionMaps.put("1", "\u6b63\u9762\u8206\u60c5");
        emotionMaps.put("0", "\u8d1f\u9762\u8206\u60c5");
    }

    @Override
    public void process(List<FacetResult> facets) {
        Iterator<String> iterators = emotionMaps.keySet().iterator();
        int size = facets.size();
        while (iterators.hasNext()) {
            boolean flag = false;
            String name = iterators.next();
            int i = 0;
            while (i < size) {
                if (name.equals(facets.get(i).getName())) {
                    flag = true;
                    break;
                }
                ++i;
            }
            if (flag) continue;
            facets.add(new FacetResult(name, 0L));
        }
        long sum = 0L;
        for (FacetResult facet : facets) {
            String name = facet.getName();
            facet.setName(emotionMaps.getOrDefault(name, "\u4e2d\u7acb\u6001\u5ea6"));
            sum += facet.getValue().longValue();
        }
        facets.add(new FacetResult("\u5168\u90e8\u8206\u60c5", sum));
    }
}

