/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.AliMappingConfig;
import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.TopicStatisticAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import com.chinamcloud.bigdata.haiheservice.bean.HotTopic;
import com.chinamcloud.bigdata.haiheservice.bean.KeyWords;
import com.chinamcloud.bigdata.haiheservice.bean.MonitorTopic;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.bean.ProvinceSentiment;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.es.service.EsDataService;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.pojo.DirectSiteNewsParams;
import com.chinamcloud.bigdata.haiheservice.pojo.GlobalHotEventParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RegionHotEventParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RegionHotNewsParams;
import com.chinamcloud.bigdata.haiheservice.pojo.TopicHotEventParams;
import com.chinamcloud.bigdata.haiheservice.service.KeyWordService;
import com.chinamcloud.bigdata.haiheservice.service.MonitorTopicService;
import com.chinamcloud.bigdata.haiheservice.service.PredictEventService;
import com.chinamcloud.bigdata.haiheservice.service.RegionService;
import com.chinamcloud.bigdata.haiheservice.util.TopicKeywordUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/index"})
public class IndexPageController {
    @Autowired
    private PredictEventService predictEventService;
    @Autowired
    private MonitorTopicService monitorTopicService;
    @Autowired
    private KeyWordService keyWordService;
    @Autowired
    private EsDataService dataService;
    @Resource(name="regionService")
    private RegionService regionService;
    private static Logger logger = LogManager.getLogger(IndexPageController.class);
    private static final User defaultUser = new User();
    private static final int productId = 53691;
    private static final int productIdRegion = 51644;
    private static final int productIdSearch = 2762;
    private static final List<Integer> productIds;
    private static final List<Integer> excludeSpiderTopicIds;

    static {
        defaultUser.setId(10026L);
        productIds = new ArrayList<Integer>();
        productIds.add(53691);
        productIds.add(51644);
        excludeSpiderTopicIds = new ArrayList<Integer>();
        excludeSpiderTopicIds.add(28931);
    }

    @RequestMapping(value={"/getEventStatistics"}, method={RequestMethod.POST})
    public Object getGlobalEventStatistics(@Valid @RequestBody GlobalHotEventParams params, BindingResult bindResult) {
        params.setProduceIds(productIds);
        params.setHistogramInterval("hour");
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setParentSource(true);
        ModelAndView view = new ModelAndView("/es/basic/topicStatistics.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/news"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getGlobalHotNews() {
        GlobalHotEventParams params = new GlobalHotEventParams();
        params.setPage(1);
        params.setSize(4);
        params.setDay("3");
        ArrayList<String> sortFields = new ArrayList<String>();
        sortFields.add("pubTime desc");
        params.setSortFields(sortFields);
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/extremeNews"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getGlobalHotNews1() {
        GlobalHotEventParams params = new GlobalHotEventParams();
        params.setPage(1);
        params.setSize(10);
        params.setDuplicate(true);
        params.setDay("3");
        ArrayList<String> sortFields = new ArrayList<String>();
        sortFields.add("emotionScore asc");
        params.setSortFields(sortFields);
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/directSiteNews"})
    public Object getDirectHotNews(@RequestBody @Validated DirectSiteNewsParams params, BindingResult result) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setProduceIds(Arrays.asList(53691));
        params.setSize(params.getSize() == null ? 4 : params.getSize());
        List<String> sourceIds = params.getSourceIds();
        params.setSourceIds(sourceIds);
        ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/predictHotEvent"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object predictHotEvent() {
        int page = 1;
        int size = 8;
        List<HotTopic> hotEvent = this.predictEventService.selectPredictEvent();
        if (hotEvent != null && hotEvent.size() > 0) {
            List<HotTopic> subList = hotEvent.subList((page - 1) * size, Math.min(page * size, hotEvent.size()));
            int totalCount = hotEvent.size();
            int totalPages = totalCount / size + 1;
            Page<HotTopic> result = new Page<HotTopic>(subList);
            result.setTotalPages(totalPages);
            result.setTotalCount(totalCount);
            return new CodeResult(CodeResult.Code.Success, result);
        }
        return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
    }

    @RequestMapping(value={"/getDefineTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getDefineTopic(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        Long userId = user.getId();
        List<MonitorTopic> list = this.monitorTopicService.selectUserSubDefineTopics(userId);
        list.forEach(x -> {
            Long uid = x.getUid();
            x.setOwner(uid != null && userId.equals(uid) ? (byte)1 : (byte)0);
        });
        if (list.size() == 0) {
            list = this.monitorTopicService.selectUserSubDefineTopics(defaultUser.getId());
        }
        return CodeResult.successResult(null, list);
    }

    @RequestMapping(value={"/getEventTrend"}, method={RequestMethod.POST})
    public Object getEventTrend(@Valid @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Long realUserId = params.getRealUserId();
        if (realUserId == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(realUserId, topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(Arrays.asList(53691, 2762));
        params.setHistogramInterval("day");
        params.setDay("7");
        ModelAndView view = new ModelAndView("/es/basic/eventTrend.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getTopicStatistics"}, method={RequestMethod.POST})
    public Object getTopicStatistics(@Valid @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Long realUserId = params.getRealUserId();
        if (realUserId == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(realUserId, topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(Arrays.asList(53691, 2762));
        params.setAfterProcessor(new TopicStatisticAfterProcessor());
        params.setHistogramInterval("day");
        params.setDay("3");
        params.setSize(3);
        ModelAndView view = new ModelAndView("/es/basic/topicStatistics.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getHotWords"}, method={RequestMethod.POST})
    public Object getHotWords(@Valid @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Long realUserId = params.getRealUserId();
        if (realUserId == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(realUserId, topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        HotParams hotParams = new HotParams();
        hotParams.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        hotParams.setProduceIds(Arrays.asList(53691, 2762));
        hotParams.setFacetField("summary_keywords");
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/userRegionTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object userRegionTopic(HttpServletRequest request) {
        List<FacetResult> provinceSentiments = null;
        try {
            HotParams hotParams = new HotParams();
            hotParams.setFacetField("monitor_topic_id");
            hotParams.setProduceIds(Arrays.asList(51644));
            provinceSentiments = this.dataService.facet(hotParams);
            for (FacetResult facet : provinceSentiments) {
                String name = AliMappingConfig.getInstance().findMonitorTopicNameById(Integer.parseInt(facet.getName()));
                facet.setName(name);
            }
            HashMap map = new HashMap();
            AliMappingConfig.getInstance().findPrivinceNames().forEach(provinceName -> {
                Integer monitorTopicId = AliMappingConfig.getInstance().findMonitorTopicIdByName((String)provinceName);
                Set<String> cityNames = this.keyWordService.getKeyWord(monitorTopicId);
                map.put(provinceName, new ArrayList<String>(cityNames));
            });
            List result = provinceSentiments.stream().map(x -> new ProvinceSentiment(x.getName(), (List)map.get(x.getName()), x.getValue(), x.getSubscribe())).collect(Collectors.toList());
            if (result.size() > 0) {
                return new CodeResult(CodeResult.Code.Success, result);
            }
        }
        catch (Exception e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
        return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
    }

    @RequestMapping(value={"/regionNews"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getRegionHotNews(@RequestBody @Validated RegionHotNewsParams params, BindingResult result) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String city = params.getCrawlerKey();
        String province = params.getTopic();
        if (!StringUtils.isEmpty((CharSequence)province)) {
            Integer monitorTopicId = AliMappingConfig.getInstance().findMonitorTopicIdByName(province);
            params.setMonitorTopicId(monitorTopicId == -1 ? null : monitorTopicId);
            if (!StringUtils.isEmpty((CharSequence)city)) {
                params.setCrawlerKeywords(Arrays.asList(city));
            }
        }
        params.setProduceIds(Arrays.asList(51644));
        params.setDuplicate(false);
        params.setSize(6);
        params.setPage(1);
        ArrayList<String> sortFields = new ArrayList<String>();
        sortFields.add("pubTime desc");
        params.setSortFields(sortFields);
        ModelAndView modelAndView = new ModelAndView("/es/basic/hotNews.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/getSenSourceFacet"}, method={RequestMethod.POST})
    public Object getRegionSentimentSourceFacet(@Valid @RequestBody RegionHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String city = params.getCrawlerKey();
        String province = params.getTopic();
        if (!StringUtils.isEmpty((CharSequence)province)) {
            Integer monitorTopicId = AliMappingConfig.getInstance().findMonitorTopicIdByName(province);
            params.setMonitorTopicId(monitorTopicId == -1 ? null : monitorTopicId);
            if (!StringUtils.isEmpty((CharSequence)city)) {
                params.setCrawlerKeywords(Arrays.asList(city));
            }
        }
        params.setFacetField("tb_nickname");
        params.setProduceIds(Arrays.asList(51644));
        params.setFacetMincount(1);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }
}

