/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.es.pojo.TermAggBucket;
import com.chinamcloud.bigdata.haiheservice.pojo.HotNewsDetailParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RegionHotEventParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RelatedNewsParams;
import com.chinamcloud.bigdata.haiheservice.service.ConfigService;
import com.chinamcloud.bigdata.haiheservice.util.TopicKeywordUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/region"})
public class RegionController {
    @Resource
    private ConfigService service;
    private static Logger logger;
    public static final Map<String, String> provinceMap;
    public static final List<String> filterCity;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block17: {
            logger = LogManager.getLogger(RegionController.class);
            provinceMap = new HashMap<String, String>();
            String path = String.valueOf(RegionController.class.getResource("/").getPath()) + File.separator + "config" + File.separator + "province.txt";
            File file = new File(path);
            if (file.exists()) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try {
                        FileReader reader = new FileReader(file);
                        try {
                            try (BufferedReader bufferedReader = new BufferedReader(reader);){
                                String temp = null;
                                while ((temp = bufferedReader.readLine()) != null) {
                                    String[] tmps = temp.split("=");
                                    provinceMap.put(tmps[0], tmps[1]);
                                }
                            }
                            if (reader == null) break block17;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (reader == null) throw throwable;
                            reader.close();
                            throw throwable;
                        }
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    logger.error("fileReader error", (Throwable)e);
                }
            }
        }
        filterCity = new ArrayList<String>();
        filterCity.add("\u5317\u4eac");
        filterCity.add("\u4e0a\u6d77");
        filterCity.add("\u5929\u6d25");
        filterCity.add("\u91cd\u5e86");
        filterCity.add("\u6fb3\u95e8");
        filterCity.add("\u9999\u6e2f");
    }

    @RequestMapping(value={"/getHotTopic"}, method={RequestMethod.POST})
    public Object getHotTopic(@Valid @RequestBody RegionHotEventParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<String> keywords = null;
        List<String> regionNames = params.getRegionNames();
        String province = params.getTopicId();
        if (regionNames.size() == 0 || StringUtils.isEmpty((CharSequence)province)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (!params.isFq()) {
            keywords = regionNames;
            if (provinceMap.containsKey(province)) {
                keywords.add(provinceMap.get(province));
            }
        } else {
            String city = regionNames.get(0);
            String county = params.getCountyId();
            keywords = filterCity.contains(province) ? Arrays.asList(city) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)county) ? Arrays.asList(county) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : null));
            if (keywords.isEmpty()) {
                return CodeResult.failedResultByMsgSource("params_error");
            }
        }
        params.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        params.setHistogramInterval("year");
        ModelAndView view = new ModelAndView("/es/basic/hotTopic.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/news"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object hotNews(@RequestBody @Validated RegionHotEventParams params, BindingResult result) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<String> keywords = null;
        List<String> regionNames = params.getRegionNames();
        String province = params.getTopicId();
        if (regionNames.size() == 0 || StringUtils.isEmpty((CharSequence)province)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (!params.isFq()) {
            keywords = regionNames;
            if (provinceMap.containsKey(province)) {
                keywords.add(provinceMap.get(province));
            }
        } else {
            String city = regionNames.get(0);
            String county = params.getCountyId();
            keywords = filterCity.contains(province) ? Arrays.asList(city) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)county) ? Arrays.asList(county) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : null));
            if (keywords.isEmpty()) {
                return CodeResult.failedResultByMsgSource("params_error");
            }
        }
        params.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        ModelAndView modelAndView = new ModelAndView("/es/basic/hotNews.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/relatedNews"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object relatedNew(@RequestBody @Validated RelatedNewsParams params, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        hotParams.setClusterId(params.getClusterId());
        hotParams.setPage(params.getPage());
        hotParams.setSize(params.getSize());
        ModelAndView modelAndView = new ModelAndView("/es/basic/relatedNews.do");
        modelAndView.addObject("params", (Object)hotParams);
        return modelAndView;
    }

    @RequestMapping(value={"/newsDetail"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object newsDetail(@RequestBody @Validated HotNewsDetailParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        HotParams hotParams = new HotParams();
        try {
            hotParams.setId(params.getDocId());
        }
        catch (NumberFormatException e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ModelAndView view = new ModelAndView("/es/basic/newsDetail.do");
        view.addObject("params", (Object)hotParams);
        view.addObject("user", (Object)user);
        return view;
    }

    @RequestMapping(value={"/getCitySentimentValue"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getCitySentimentValue(@RequestBody Map<String, Object> params) {
        Object tmpRegionNames = params.get("regionNames");
        ModelAndView view = null;
        if (tmpRegionNames != null) {
            List regionNames = (List)tmpRegionNames;
            if (regionNames.isEmpty()) {
                return CodeResult.successResult(null, Collections.emptyList());
            }
            HotParams hotParams = new HotParams();
            hotParams.setDescription(TopicKeywordUtils.buildQueryByStr(regionNames));
            view = new ModelAndView("/es/basic/termBucketAgg.do");
            view.addObject("params", (Object)hotParams);
            view.addObject("termBucket", regionNames.stream().map(x -> new TermAggBucket(Arrays.asList(x), "description", (String)x)).collect(Collectors.toList()));
        }
        return view;
    }
}

