/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.CatSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class CatSiteStatisticDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<CatSite> findCatSpiderTopicIdList() {
        return this.jdbcTemplate.query("SELECT `sourceId`,`comment`,`spiderTopicId`,`category` FROM `t_category_medialib` group by spiderTopicId", (RowMapper)new RowMapper<CatSite>(){

            public CatSite mapRow(ResultSet rs, int rowNum) throws SQLException {
                CatSite bean = new CatSite();
                bean.setSpiderTopicId(rs.getInt("spiderTopicId"));
                bean.setCategory(rs.getString("category"));
                return bean;
            }
        });
    }

    public List<CatSite> findCatSiteList(Integer spiderTopicId) {
        String sql = "SELECT spiderTopicId,sourceId,`comment`,`category` FROM `t_category_medialib`";
        sql = spiderTopicId == -1 ? String.valueOf(sql) + " WHERE spiderTopicId !=? " : String.valueOf(sql) + " WHERE spiderTopicId =? ";
        return this.jdbcTemplate.query(sql, new Object[]{spiderTopicId}, (RowMapper)new RowMapper<CatSite>(){

            public CatSite mapRow(ResultSet rs, int rowNum) throws SQLException {
                CatSite bean = new CatSite();
                bean.setSourceId(rs.getInt("sourceId"));
                bean.setName(rs.getString("comment"));
                bean.setSpiderTopicId(rs.getInt("spiderTopicId"));
                bean.setCategory(rs.getString("category"));
                return bean;
            }
        });
    }
}

