/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es;

import com.chinamcloud.bigdata.haiheservice.es.EsConfig;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;

public class EsClientFactory {
    private static Logger logger = LogManager.getLogger(EsClientFactory.class);

    public static TransportClient getClient() {
        PreBuiltXPackTransportClient client = null;
        EsConfig conf = EsConfig.getConf();
        try {
            String[] hosts;
            Settings settings = Settings.builder().put("cluster.name", conf.getClusterName()).put("xpack.security.transport.ssl.enabled", false).put("xpack.security.user", conf.getUserPwd()).build();
            client = new PreBuiltXPackTransportClient(settings, new Class[0]);
            String[] stringArray = hosts = conf.getEsHost().split(",");
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(s), conf.getEsPort()));
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.info("es start success");
        return client;
    }
}

