/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es;

import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EsConfig {
    private static Logger logger = LogManager.getLogger(EsConfig.class);
    private static final String CONF_PATH = "config/es.properties";
    private final String esHost;
    private final int esPort;
    private final String clusterName;
    private final String indexName;
    private final String typeName;
    private final String userPwd;

    public EsConfig() {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(EsConfig.class.getClassLoader().getResourceAsStream(CONF_PATH), "UTF-8"));
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
            System.exit(0);
        }
        this.esHost = properties.getProperty("es_host");
        this.esPort = Integer.valueOf(properties.getProperty("es_port"));
        this.clusterName = properties.getProperty("cluster_name");
        this.indexName = properties.getProperty("index_name");
        this.typeName = properties.getProperty("type_name");
        this.userPwd = properties.getProperty("user_pwd");
    }

    public static EsConfig getConf() {
        return Holder.INSTANCE;
    }

    public String getEsHost() {
        return this.esHost;
    }

    public int getEsPort() {
        return this.esPort;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getUserPwd() {
        return this.userPwd;
    }

    private static class Holder {
        static EsConfig INSTANCE = new EsConfig();

        private Holder() {
        }
    }
}

