/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es;

import com.chinamcloud.bigdata.haiheservice.es.EsConst;
import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.IEsFeedbackQueryProcessor;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;

public class ParamsEsFeedBackQueryProcessor
implements IEsFeedbackQueryProcessor {
    private static Map<String, String> sortFieldsMaping = new HashMap<String, String>();
    private static Map<String, String> facetFieldMapping;
    private static Logger logger;
    private EsFeedbackQuery feedbackQuery;
    private HotParams params;

    static {
        sortFieldsMaping.put("pubTime", "pubTime");
        sortFieldsMaping.put("pointsCount", "pointsCount");
        sortFieldsMaping.put("emotionScore", "emotionScore");
        sortFieldsMaping.put("createdAt", "createdAt");
        facetFieldMapping = new HashMap<String, String>();
        facetFieldMapping.put("monitor_topic_id", "monitorTopicId");
        facetFieldMapping.put("crawler_keywords", "crawlerKeywords");
        facetFieldMapping.put("emotion_tendency", "emotionTendency");
        facetFieldMapping.put("parent_source", "parentSource");
        facetFieldMapping.put("tb_nickname", "tbNickname");
        facetFieldMapping.put("source_id", "sourceId");
        facetFieldMapping.put("summary_keywords", "summaryKeywordList");
        facetFieldMapping.put("spider_topicId", "spiderTopicId");
        facetFieldMapping.put("source", "source");
        logger = LogManager.getLogger(ParamsEsFeedBackQueryProcessor.class);
    }

    public ParamsEsFeedBackQueryProcessor(HotParams params) {
        this.params = params;
    }

    protected void setParams() {
        this.setDt().setCrawlerDt().setPageIndex().setPageSize().setSortFields().setFacetFields().setEmotionTendency().setSummaryKeyWords().setClusterId().setDescription().setContent().setSourceIds().setCluster().setSpiderTopicIds().setExcludeSpiderTopicIds().setMonitorTopicId().setCrawlerKeywords().setProductIds().setDocId().setTbNickName().setFacetLimit().setFacetMincount().setInterval().setDateHistogramInterval().setHistogramInterval().setSource().setSubject().setEmotionUpper().setEmotionLower().setIsParentSource();
    }

    protected ParamsEsFeedBackQueryProcessor setDt() {
        String day;
        Date fromDt = this.params.getFromDt();
        Date toDt = this.params.getToDt();
        if (fromDt == null && toDt == null && !StringUtils.isEmpty((CharSequence)(day = this.params.getDay()))) {
            Date[] dates = null;
            try {
                dates = DateUtils.computeDatesBackward(Integer.valueOf(day), false);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
            fromDt = dates[0];
            toDt = dates[1];
        }
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        if (!DateUtils.isDateAfter(fromDt, toDt)) {
            throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
        }
        if (fromDt != null) {
            this.feedbackQuery.setPubTimeBegin(fastDateFormat.format(fromDt));
        }
        if (toDt != null) {
            this.feedbackQuery.setPubTimeEnd(fastDateFormat.format(toDt));
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setCrawlerDt() {
        Date fromDt = this.params.getFromCrawlerDt();
        Date toDt = this.params.getToCrawlerDt();
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        if (fromDt != null && toDt != null) {
            if (!DateUtils.isDateAfter(fromDt, toDt)) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
            this.feedbackQuery.setCreatedAtBegin(fastDateFormat.format(fromDt));
            this.feedbackQuery.setCreatedAtEnd(fastDateFormat.format(toDt));
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setPageIndex() {
        this.feedbackQuery.setPageIndex(this.params.getPage());
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setPageSize() {
        int size = this.params.getSize();
        if (size > 0) {
            this.feedbackQuery.setPageSize(size);
        } else {
            this.feedbackQuery.setPageSize(0);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSortFields() {
        List<String> sortFields = this.params.getSortFields();
        ArrayList<String> sortMethod = new ArrayList<String>();
        if (sortFields != null && sortFields.size() > 0) {
            for (String field : sortFields) {
                String[] splitFields = field.split(" ");
                String fieldName = "";
                String sortType = "";
                if (splitFields.length > 0 && (fieldName = sortFieldsMaping.get(splitFields[0].trim())) == null) {
                    throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
                }
                if (splitFields.length > 1 && !"desc".equals(sortType = splitFields[1].trim().toLowerCase()) && !"asc".equals(sortType)) {
                    throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
                }
                if (sortType.length() > 0) {
                    sortMethod.add(String.valueOf(fieldName) + " " + sortType);
                    continue;
                }
                sortMethod.add(fieldName);
            }
        } else {
            sortMethod.add("pubTime desc");
        }
        this.feedbackQuery.setSortingMethods(sortMethod);
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setEmotionTendency() {
        String emotionTendency = this.params.getEmotionTendency();
        if (!StringUtils.isEmpty((CharSequence)emotionTendency)) {
            this.feedbackQuery.setEmotionTendency(Integer.valueOf(emotionTendency));
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSummaryKeyWords() {
        List<String> summaryKeyWords = this.params.getSummaryKeywordList();
        if (summaryKeyWords != null && summaryKeyWords.size() > 0) {
            this.feedbackQuery.setSummaryKeywords(summaryKeyWords);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setClusterId() {
        if (StringUtils.isNotBlank((CharSequence)this.params.getClusterId())) {
            try {
                this.feedbackQuery.setClusterId(Long.valueOf(this.params.getClusterId()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setDescription() {
        String description = this.params.getDescription();
        if (!StringUtils.isEmpty((CharSequence)description)) {
            this.feedbackQuery.setDescription(description);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setContent() {
        String content = this.params.getContent();
        if (!StringUtils.isEmpty((CharSequence)content)) {
            this.feedbackQuery.setContentShouldContain(content);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setCluster() {
        if (StringUtils.isNotBlank((CharSequence)this.params.getCluster())) {
            this.feedbackQuery.setCluster(this.params.getCluster());
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setClusteFlag() {
        Integer clusterFlag = this.params.getClusterFlag();
        if (clusterFlag != null) {
            this.feedbackQuery.setClusterFlag(clusterFlag);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setFacetFields() {
        if (!StringUtils.isEmpty((CharSequence)this.params.getFacetField())) {
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(facetFieldMapping.get(this.params.getFacetField()));
            this.feedbackQuery.setFacetField(facetFieldMapping.get(this.params.getFacetField()));
            this.feedbackQuery.setFacetFields(fields);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSourceIds() {
        List<String> sourceIds = this.params.getSourceIds();
        if (sourceIds != null) {
            try {
                this.feedbackQuery.setSourceIds(sourceIds.stream().map(x -> Integer.valueOf(x)).collect(Collectors.toList()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setCrawlerKeywords() {
        List<String> getCrawlerKeywords = this.params.getCrawlerKeywords();
        if (getCrawlerKeywords != null) {
            this.feedbackQuery.setCrawlerKeywords(getCrawlerKeywords);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSpiderTopicIds() {
        List<Integer> spiderTopicIds = this.params.getSpiderTopicIds();
        if (spiderTopicIds != null) {
            this.feedbackQuery.setSpiderTopicIds(spiderTopicIds);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setExcludeSpiderTopicIds() {
        List<Integer> excludeSpiderTopicIds = this.params.getExcludeSpiderTopicIds();
        if (excludeSpiderTopicIds != null) {
            this.feedbackQuery.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setMonitorTopicId() {
        Integer monitorTopicId = this.params.getMonitorTopicId();
        if (monitorTopicId != null) {
            this.feedbackQuery.setMonitorTopicId(monitorTopicId);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setProductIds() {
        List<Integer> produceIds = this.params.getProduceIds();
        if (produceIds != null && produceIds.size() > 0) {
            this.feedbackQuery.setProductIds(produceIds);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setDocId() {
        String docId = this.params.getId();
        if (docId != null) {
            this.feedbackQuery.setId(docId);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setTbNickName() {
        List<String> tbNicknames = this.params.getTbNickNames();
        if (tbNicknames != null && tbNicknames.size() > 0) {
            this.feedbackQuery.setTbNicknames(tbNicknames);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setFacetLimit() {
        Integer facetLimit = this.params.getFacetLimit();
        if (facetLimit != null) {
            this.feedbackQuery.setFacetLimit(facetLimit);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setFacetMincount() {
        Integer facetMincount = this.params.getFacetMincount();
        if (facetMincount != null) {
            this.feedbackQuery.setFacetMincount(facetMincount);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setInterval() {
        String interval = this.params.getInterval();
        if (interval != null) {
            this.feedbackQuery.setFacetInterval(interval);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setDateHistogramInterval() {
        block28: {
            String interval = this.params.getDateInterval();
            DateHistogramInterval type = null;
            if (interval == null) break block28;
            switch (interval) {
                case "second": {
                    type = EsConst.DateHistogram.SECOND;
                    break;
                }
                case "minute": {
                    type = EsConst.DateHistogram.MINUTE;
                    break;
                }
                case "quarter": {
                    type = EsConst.DateHistogram.QUARTER;
                    break;
                }
                case "hour": {
                    type = EsConst.DateHistogram.HOUR;
                    break;
                }
                case "day": {
                    type = EsConst.DateHistogram.DAY;
                    break;
                }
                case "week": {
                    type = EsConst.DateHistogram.WEEK;
                    break;
                }
                case "month": {
                    type = EsConst.DateHistogram.MONTH;
                    break;
                }
                case "year": {
                    type = EsConst.DateHistogram.YEAR;
                    break;
                }
            }
            this.feedbackQuery.setFacetDateHistogramInterval(type);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setHistogramInterval() {
        block28: {
            String interval = this.params.getHistogramInterval();
            Double type = null;
            if (interval == null) break block28;
            switch (interval) {
                case "second": {
                    type = 1000.0;
                    break;
                }
                case "minute": {
                    type = 60000.0;
                    break;
                }
                case "quarter": {
                    type = 900000.0;
                    break;
                }
                case "hour": {
                    type = 3600000.0;
                    break;
                }
                case "day": {
                    type = 8.64E7;
                    break;
                }
                case "week": {
                    type = 6.048E8;
                    break;
                }
                case "month": {
                    type = 2.592E9;
                    break;
                }
                case "year": {
                    type = 3.1536E10;
                    break;
                }
            }
            this.feedbackQuery.setFacetHistogramInterval(type);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSource() {
        List<String> newsType = this.params.getNewsType();
        if (newsType != null && !newsType.get(0).equals("all")) {
            this.feedbackQuery.setSources(newsType);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSubject() {
        String subject = this.params.getSubject();
        if (subject != null) {
            this.feedbackQuery.setSubject(subject);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setEmotionUpper() {
        Integer upper = this.params.getEmotionUpper();
        if (upper != null) {
            this.feedbackQuery.setEmotionScoreUpper(upper);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setEmotionLower() {
        Integer lower = this.params.getEmotionLower();
        if (lower != null) {
            this.feedbackQuery.setEmotionScoreLower(lower);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setIsParentSource() {
        boolean parentSource = this.params.isParentSource();
        if (parentSource) {
            this.feedbackQuery.setParentSource(parentSource);
        }
        return this;
    }

    @Override
    public void process(EsFeedbackQuery query) throws Exception {
        this.feedbackQuery = query;
        this.setParams();
    }

    public class ConfigMappingNoDataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ConfigMappingNoDataException(String message) {
            super(message);
        }
    }
}

