/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.parser;

import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsSearchField;
import com.chinamcloud.bigdata.haiheservice.es.result.EsPagedResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsSearchResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class NewsDetailParser2 {
    private SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public List<HotNews> parseRecords(EsPagedResult<EsSearchResult> result) {
        List<EsApsSearchField> records = ((EsSearchResult)result.getResult()).getRecords();
        ArrayList<HotNews> list = new ArrayList<HotNews>();
        if (records != null && records.size() > 0) {
            for (EsApsSearchField feedback : records) {
                HotNews hotNew = new HotNews();
                hotNew.setTitle(feedback.getSubject());
                hotNew.setPubTime(this.dateFormat2.format(feedback.getPubTime()));
                hotNew.setSrc(feedback.getTbNickname());
                hotNew.setUrl(feedback.getRefererUrl());
                hotNew.setKeywords(feedback.getSummaryKeywordList());
                String description = feedback.getDescription();
                if (StringUtils.isEmpty((CharSequence)description)) {
                    description = "";
                }
                hotNew.setDescription(description);
                hotNew.setPics(feedback.getPics());
                list.add(hotNew);
            }
        }
        return list;
    }
}

