/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.service;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import com.chinamcloud.bigdata.haiheservice.bean.HotEvent;
import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import com.chinamcloud.bigdata.haiheservice.bean.HotTopic;
import com.chinamcloud.bigdata.haiheservice.bean.HotTopicTrend;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQueryBuilderManager;
import com.chinamcloud.bigdata.haiheservice.es.ParamsEsFeedBackQueryProcessor;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsFacetField;
import com.chinamcloud.bigdata.haiheservice.es.bean.HotEventStatistic;
import com.chinamcloud.bigdata.haiheservice.es.bean.HotTopicStatistic;
import com.chinamcloud.bigdata.haiheservice.es.dao.EsBaseDao;
import com.chinamcloud.bigdata.haiheservice.es.parser.FacetDataParser;
import com.chinamcloud.bigdata.haiheservice.es.parser.FacetDataWithCondtionParser;
import com.chinamcloud.bigdata.haiheservice.es.parser.HotEventDataParser;
import com.chinamcloud.bigdata.haiheservice.es.parser.HotNewsDataParser;
import com.chinamcloud.bigdata.haiheservice.es.parser.HotTopicDataParser;
import com.chinamcloud.bigdata.haiheservice.es.parser.HotTopicTrendDataParser;
import com.chinamcloud.bigdata.haiheservice.es.parser.NewsDetailParser;
import com.chinamcloud.bigdata.haiheservice.es.parser.NewsDetailParser2;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildDateHistogramAgg;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildEventStatisticAgg;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildHistogramAgg;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildQuery;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildSort;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildTopicStatisticAgg;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuilderPos;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsFactAggWithEmotionTendency;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsHotEventAndNewsAgg;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsQueryParams;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsTermBucketAgg;
import com.chinamcloud.bigdata.haiheservice.es.pojo.TermAggBucket;
import com.chinamcloud.bigdata.haiheservice.es.result.EsEventStatisticResultProcessor;
import com.chinamcloud.bigdata.haiheservice.es.result.EsFacetResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsFacetResultProcessor;
import com.chinamcloud.bigdata.haiheservice.es.result.EsFacetResultWitnCondtionProcessor;
import com.chinamcloud.bigdata.haiheservice.es.result.EsHistogramResultProcessor;
import com.chinamcloud.bigdata.haiheservice.es.result.EsNewsProcessor;
import com.chinamcloud.bigdata.haiheservice.es.result.EsPagedResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsSearchResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsTopicStatisticResultProcessor;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EsDataService {
    @Autowired
    private EsBaseDao dao;
    private static Logger logger = LogManager.getLogger(EsDataService.class);

    public Page<HotEvent> queryHotEvent(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams), x -> {
            x.setFacetField("clusterId");
            x.setClusterKeywod(true);
        });
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsHotEventAndNewsAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsNewsProcessor processor = new EsNewsProcessor();
        EsPagedResult<EsSearchResult> esResult = processor.processReuslt(query, response, null);
        HotEventDataParser parser = new HotEventDataParser();
        Page<HotEvent> result = parser.parseRecords(esResult);
        return result;
    }

    public Page<HotNews> queryHotNewsSearch(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setPos(EsBuilderPos.getSearchPos(query));
        params.setSort(EsBuildSort.getSearchSort(query));
        SearchResponse response = this.dao.searcher(params);
        EsNewsProcessor processor = new EsNewsProcessor();
        EsPagedResult<EsSearchResult> esResult = processor.processReuslt(query, response);
        HotNewsDataParser parser = new HotNewsDataParser();
        Page<HotNews> result = parser.parseRecords(esResult);
        return result;
    }

    public List<HotNews> exportNews(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setPos(EsBuilderPos.getSearchPos(query));
        params.setSort(EsBuildSort.getSearchSort(query));
        SearchResponse response = this.dao.searcher(params);
        EsNewsProcessor processor = new EsNewsProcessor();
        EsPagedResult<EsSearchResult> esResult = processor.processReuslt(query, response);
        NewsDetailParser2 parser = new NewsDetailParser2();
        List<HotNews> result = parser.parseRecords(esResult);
        return result;
    }

    public HotNews queryNewsDetail(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setPos(EsBuilderPos.getSearchPos(query));
        params.setSort(EsBuildSort.getSearchSort(query));
        SearchResponse response = this.dao.searcher(params);
        EsNewsProcessor processor = new EsNewsProcessor();
        EsPagedResult<EsSearchResult> esResult = processor.processReuslt(query, response);
        NewsDetailParser parser = new NewsDetailParser();
        HotNews result = parser.parseRecords(esResult);
        return result;
    }

    public List<FacetResult> facet(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams), x -> x.setFacetMincount(1));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsFactAggWithEmotionTendency().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsFacetResultProcessor processor = new EsFacetResultProcessor();
        EsFacetResult<List<EsApsFacetField>> esResult = processor.processResult(query, response);
        FacetDataParser parser = new FacetDataParser();
        List<FacetResult> result = parser.parseRecords((List)esResult.getResult());
        return result;
    }

    public List<FacetResult> facetWithCondition(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams), x -> x.setFacetMincount(1));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsFactAggWithEmotionTendency().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsFacetResultWitnCondtionProcessor processor = new EsFacetResultWitnCondtionProcessor();
        EsFacetResult<List<EsApsFacetField>> esResult = processor.processResult(query, response);
        FacetDataWithCondtionParser parser = new FacetDataWithCondtionParser();
        List<FacetResult> result = parser.parseRecords((List)esResult.getResult());
        return result;
    }

    public List<FacetResult> dateHistogram(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsBuildDateHistogramAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsHistogramResultProcessor processor = new EsHistogramResultProcessor();
        EsFacetResult<List<EsApsFacetField>> esResult = processor.processResult(query, response);
        FacetDataParser parser = new FacetDataParser();
        List<FacetResult> result = parser.parseRecords((List)esResult.getResult());
        return result;
    }

    public List<FacetResult> histogram(HotParams hotParams, String intervalType) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsBuildHistogramAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsHistogramResultProcessor processor = new EsHistogramResultProcessor();
        EsFacetResult<List<EsApsFacetField>> esResult = processor.processResult(query, response);
        FacetDataParser parser = new FacetDataParser();
        List<FacetResult> result = parser.parseRecords((List)esResult.getResult());
        return result;
    }

    public HotEventStatistic hotEventStatistic(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsBuildEventStatisticAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsEventStatisticResultProcessor processor = new EsEventStatisticResultProcessor();
        HotEventStatistic hotEventStatistic = processor.processResult(query, response);
        return hotEventStatistic;
    }

    public List<HotTopicStatistic> hotTopicStatistic(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams), x -> x.setClusterKeywod(true));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsBuildTopicStatisticAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsTopicStatisticResultProcessor processor = new EsTopicStatisticResultProcessor();
        List<HotTopicStatistic> result = processor.processResult(query, response);
        return result;
    }

    public Page<HotTopic> hotTopic(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams), x -> x.setClusterKeywod(true));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsBuildTopicStatisticAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsTopicStatisticResultProcessor processor = new EsTopicStatisticResultProcessor();
        List<HotTopicStatistic> esResult = processor.processResult(query, response);
        HotTopicDataParser parser = new HotTopicDataParser();
        Page<HotTopic> result = parser.parseRecords(esResult);
        List<HotTopic> records = result.getRecords();
        int pageIndex = hotParams.getPage();
        int pageSize = hotParams.getSize();
        int fromIndex = Math.min((pageIndex - 1) * pageSize, records.size());
        int toIndex = Math.min(pageIndex * pageSize, records.size());
        if (fromIndex < toIndex) {
            result.setRecords(records.subList(fromIndex, toIndex));
            result.setTotalCount(result.getRecords().size());
        } else {
            result.setRecords(Collections.emptyList());
            result.setTotalCount(0);
        }
        return result;
    }

    public HotTopicTrend hotTopicTrend(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams), x -> x.setClusterKeywod(true));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsBuildTopicStatisticAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsTopicStatisticResultProcessor processor = new EsTopicStatisticResultProcessor();
        List<HotTopicStatistic> esResult = processor.processResult(query, response);
        HotTopicTrendDataParser parser = new HotTopicTrendDataParser();
        HotTopicTrend result = parser.parseRecords(esResult);
        return result;
    }

    public List<FacetResult> termBucketFacet(HotParams hotParams, List<TermAggBucket> termAggBucket) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams), x -> {
            x.setFacetMincount(1);
            x.setFacetLimit(Integer.MAX_VALUE);
        });
        EsQueryParams params = new EsQueryParams();
        query.setTermAggBuckets(termAggBucket);
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsTermBucketAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsFacetResultProcessor processor = new EsFacetResultProcessor();
        EsFacetResult<List<EsApsFacetField>> esResult = processor.processResult(query, response);
        FacetDataParser parser = new FacetDataParser();
        List<FacetResult> result = parser.parseRecords((List)esResult.getResult());
        return result;
    }

    public Page<HotNews> queryHotNewsCluster(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams), x -> {
            x.setFacetField("cluster.keyword");
            x.setFacetMincount(1);
        });
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsHotEventAndNewsAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsNewsProcessor processor = new EsNewsProcessor();
        EsPagedResult<EsSearchResult> esResult = processor.processReuslt(query, response, null);
        HotNewsDataParser parser = new HotNewsDataParser();
        Page<HotNews> result = parser.parseRecords(esResult);
        List<HotNews> records = result.getRecords();
        int pageIndex = hotParams.getPage();
        int pageSize = hotParams.getSize();
        int fromIndex = Math.min((pageIndex - 1) * pageSize, records.size());
        int toIndex = Math.min(pageIndex * pageSize, records.size());
        if (fromIndex < toIndex) {
            result.setRecords(records.subList(fromIndex, toIndex));
            result.setTotalCount(result.getRecords().size());
        } else {
            result.setRecords(Collections.emptyList());
            result.setTotalCount(0);
        }
        return result;
    }

    public Integer statisticNews(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        logger.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setPos(EsBuilderPos.getSearchPos(query));
        params.setSort(EsBuildSort.getSearchSort(query));
        SearchResponse response = this.dao.searcher(params);
        EsNewsProcessor processor = new EsNewsProcessor();
        EsPagedResult<EsSearchResult> esResult = processor.processReuslt(query, response);
        Integer totalCount = esResult.getTotalCount();
        return totalCount;
    }
}

