/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import com.chinamcloud.bigdata.haiheservice.util.JSONUtils;
import com.chinamcloud.bigdata.haiheservice.xz.PageParser;
import com.taobao.kelude.aps.feedback.model.ApsFeedback;
import com.taobao.kelude.aps.feedback.model.SearchResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HotNewsDataParser
extends PageParser<HotNews, SearchResult> {
    private SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    @Override
    protected List<HotNews> parseRecords(SearchResult result) {
        ArrayList<HotNews> news = new ArrayList<HotNews>();
        for (ApsFeedback apsFeedback : result.getRecords()) {
            HotNews hotNew = new HotNews();
            hotNew.setAuthor(apsFeedback.getTbNickname());
            hotNew.setCity(apsFeedback.getCrawlerKeywords());
            hotNew.setDocId(String.valueOf(apsFeedback.getId()));
            hotNew.setEmotionScore(apsFeedback.getEmotionScore());
            hotNew.setEmotionTendency(apsFeedback.getEmotionTendency());
            hotNew.setSimilarity(apsFeedback.getPointsCount());
            hotNew.setPubTime(this.dateFormat2.format(apsFeedback.getPubTime()));
            hotNew.setTitle(apsFeedback.getSubject());
            hotNew.setDescription(apsFeedback.getDescription());
            hotNew.setUrl(apsFeedback.getRefererUrl());
            hotNew.setClusterId(apsFeedback.getClusterId());
            hotNew.setCluster(apsFeedback.getSubject());
            hotNew.setParentSource(apsFeedback.getTbNickname());
            hotNew.setSourceId(apsFeedback.getSourceId());
            hotNew.setPics(this.parsePics(apsFeedback.getCfs()));
            news.add(hotNew);
        }
        return news;
    }

    private List<String> parsePics(Map<String, String> cfsMap) {
        JSONArray jsonArray;
        String valueStr;
        ArrayList<String> picUrls = new ArrayList<String>();
        if (cfsMap != null && !StringUtils.isEmpty((CharSequence)(valueStr = cfsMap.get("101148"))) && (jsonArray = JSONUtils.parseJSONArray(valueStr)) != null) {
            int jsonArrayLength = jsonArray.size();
            int i = 0;
            while (i < jsonArrayLength) {
                JSONObject attachment = jsonArray.getJSONObject(i);
                String picUrl = attachment.getString("url");
                if (!StringUtils.isEmpty((CharSequence)picUrl)) {
                    picUrls.add(picUrl);
                }
                ++i;
            }
        }
        return picUrls;
    }
}

