/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.service;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.bigdata.haiheservice.DatasourceRequestProcessor;
import com.chinamcloud.bigdata.haiheservice.FeedbackQueryBuilderManager;
import com.chinamcloud.bigdata.haiheservice.HttpRequestSource;
import com.chinamcloud.bigdata.haiheservice.IDataParser;
import com.chinamcloud.bigdata.haiheservice.MapQueryBuilderManager;
import com.chinamcloud.bigdata.haiheservice.PageRequestProcessor;
import com.chinamcloud.bigdata.haiheservice.PageRequestSource;
import com.chinamcloud.bigdata.haiheservice.ParamsFeedBackQueryProcessor;
import com.chinamcloud.bigdata.haiheservice.ParamsMapQueryProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.AliWeiboAnalysisResult;
import com.chinamcloud.bigdata.haiheservice.bean.AliWeiboSubmitResult;
import com.chinamcloud.bigdata.haiheservice.bean.Emotion;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import com.chinamcloud.bigdata.haiheservice.bean.HotEvent;
import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import com.chinamcloud.bigdata.haiheservice.bean.HotWords;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.bean.PageDataIterator;
import com.chinamcloud.bigdata.haiheservice.bean.SenSourceFacet;
import com.chinamcloud.bigdata.haiheservice.parser.AliKeywordsParser;
import com.chinamcloud.bigdata.haiheservice.parser.EmotionDataParser;
import com.chinamcloud.bigdata.haiheservice.parser.FacetDataParser;
import com.chinamcloud.bigdata.haiheservice.parser.HotEventDataParser;
import com.chinamcloud.bigdata.haiheservice.parser.HotNewsDataParser;
import com.chinamcloud.bigdata.haiheservice.parser.HotWordsDataParser;
import com.chinamcloud.bigdata.haiheservice.parser.NewsDetailParser;
import com.chinamcloud.bigdata.haiheservice.parser.SenSourceFacetParser;
import com.chinamcloud.bigdata.haiheservice.parser.WeiboResultParser;
import com.chinamcloud.bigdata.haiheservice.parser.WeiboSubmitParser;
import com.chinamcloud.bigdata.haiheservice.pojo.AliKeywordsAddParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.pojo.MapParams;
import com.chinamcloud.bigdata.haiheservice.pojo.NewsDetailParams;
import com.chinamcloud.bigdata.haiheservice.service.IQueryDataService;
import com.chinamcloud.bigdata.haiheservice.util.ConfigureUtils;
import com.taobao.kelude.aps.feedback.model.FeedbackQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="alidataservice")
public class AliDataService
implements IQueryDataService {
    private static Logger logger = LogManager.getLogger(AliDataService.class);

    @Override
    public Page<HotEvent> queryHotEvent(HotParams params) throws Exception {
        List<String> summaryKeyWordList = params.getSummaryKeywordList();
        if (summaryKeyWordList != null && summaryKeyWordList.size() > 0) {
            params.setDay("2");
        }
        FeedbackQuery query = FeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsFeedBackQueryProcessor(params));
        PageRequestProcessor<HotEvent> processor = new PageRequestProcessor<HotEvent>(new PageRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "baseSearchFull.do", query), (IDataParser)new HotEventDataParser()){

            @Override
            public void mergeList(List<HotEvent> list) {
                ArrayList newList = new ArrayList(list.stream().collect(Collectors.toMap(x -> x.getCluster(), x -> x, (x, y) -> x, LinkedHashMap::new)).values());
                list.clear();
                list.addAll(newList);
            }

            @Override
            public boolean filter(HotEvent t) {
                return !t.getTitle().equals(t.getDescription()) && t.getCount() > 1L;
            }
        };
        return processor.processRequest();
    }

    @Override
    public Page<HotNews> queryHotNews(HotParams params) throws Exception {
        FeedbackQuery query = FeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsFeedBackQueryProcessor(params));
        PageRequestProcessor processor = null;
        processor = StringUtils.isEmpty((CharSequence)params.getClusterId()) ? new PageRequestProcessor<HotNews>(new PageRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "baseSearchFull.do", query), (IDataParser)new HotNewsDataParser()){

            @Override
            public void mergeList(List<HotNews> list) {
                ArrayList newList = new ArrayList(list.stream().collect(Collectors.toMap(x -> x.getCluster(), x -> x, (x, y) -> x, LinkedHashMap::new)).values());
                list.clear();
                list.addAll(newList);
            }

            @Override
            public boolean filter(HotNews t) {
                return !t.getTitle().equals(t.getDescription());
            }
        } : new PageRequestProcessor<HotNews>(new PageRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "baseSearchFull.do", query), (IDataParser)new HotNewsDataParser()){

            @Override
            public void afterProcessor(Page<HotNews> pages) {
                List<HotNews> list = pages.getRecords();
                if (list.size() == 1) {
                    list.clear();
                    pages.setTotalCount(0);
                }
            }
        };
        return (Page)((DatasourceRequestProcessor)processor).processRequest();
    }

    @Override
    public Page<HotNews> queryHotNewsBase(HotParams params) throws Exception {
        FeedbackQuery query = FeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsFeedBackQueryProcessor(params));
        DatasourceRequestProcessor<String, Page<HotNews>> processor = new DatasourceRequestProcessor<String, Page<HotNews>>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "baseSearchFull.do", JSON.toJSONString((Object)query)), new HotNewsDataParser());
        return processor.processRequest();
    }

    @Override
    public HotNews queryNewsDetail(HotParams params) throws Exception {
        params.setWordCut(0);
        FeedbackQuery query = FeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsFeedBackQueryProcessor(params));
        DatasourceRequestProcessor<String, HotNews> processor = new DatasourceRequestProcessor<String, HotNews>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "baseSearch.do", JSON.toJSONString((Object)query)), new NewsDetailParser());
        return processor.processRequest();
    }

    @Override
    public HotNews queryHotNews(NewsDetailParams params) throws Exception {
        FeedbackQuery query = FeedbackQueryBuilderManager.processWithGlobalProceesor(x -> {
            Long docId = Long.valueOf(params.getDocId());
            x.setId(docId);
            x.setWordCut(Integer.valueOf(0));
        });
        DatasourceRequestProcessor<String, HotNews> processor = new DatasourceRequestProcessor<String, HotNews>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "baseSearch.do", JSON.toJSONString((Object)query)), new NewsDetailParser());
        return processor.processRequest();
    }

    @Override
    public List<HotWords> queryHotWords(MapParams params) throws Exception {
        Map<String, Object> query = MapQueryBuilderManager.processWithMapProceesor(new ParamsMapQueryProcessor(params));
        logger.info("queryHotWords=" + query.toString());
        DatasourceRequestProcessor<String, List<HotWords>> processor = new DatasourceRequestProcessor<String, List<HotWords>>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "queryAliyunHotWord.do", JSON.toJSONString(query)), new HotWordsDataParser());
        return processor.processRequest();
    }

    @Override
    public List<HotWords> queryXZHotWords(MapParams params) throws Exception {
        Map<String, Object> query = MapQueryBuilderManager.processWithMapProceesor(new ParamsMapQueryProcessor(params));
        logger.info("queryXZHotWords=" + query.toString());
        DatasourceRequestProcessor<String, List<HotWords>> processor = new DatasourceRequestProcessor<String, List<HotWords>>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "queryOuterHotWord.do", JSON.toJSONString(query)), new HotWordsDataParser());
        return processor.processRequest();
    }

    @Override
    public List<FacetResult> facet(HotParams params) throws Exception {
        FeedbackQuery query = FeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsFeedBackQueryProcessor(params));
        logger.info("facet=" + query.getTsearchQueryString());
        DatasourceRequestProcessor<String, List<FacetResult>> processor = new DatasourceRequestProcessor<String, List<FacetResult>>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "queryFacetSearch.do", JSON.toJSONString((Object)query)), new FacetDataParser());
        return processor.processRequest();
    }

    @Override
    public AliWeiboSubmitResult submitWeiboAnalysis(String weiboUrl, Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("weiboUrl", weiboUrl.replace("https", "http"));
        map.put("userId", userId);
        logger.info("submitWeiboAnalysisq=" + ((Object)map).toString());
        DatasourceRequestProcessor<String, AliWeiboSubmitResult> processor = new DatasourceRequestProcessor<String, AliWeiboSubmitResult>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "weiboSubmitAnalysis.do", JSON.toJSONString(map)), new WeiboSubmitParser());
        return processor.processRequest();
    }

    @Override
    public AliWeiboSubmitResult submitWeiboAnalysis(String weiboUrl, Integer userId, Integer productId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("weiboUrl", weiboUrl.replace("https", "http"));
        map.put("userId", userId);
        map.put("productId", productId);
        logger.info("submitWeiboAnalysis=" + ((Object)map).toString());
        DatasourceRequestProcessor<String, AliWeiboSubmitResult> processor = new DatasourceRequestProcessor<String, AliWeiboSubmitResult>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "weiboSubmitAnalysisWithProductId.do", JSON.toJSONString(map)), new WeiboSubmitParser());
        return processor.processRequest();
    }

    @Override
    public AliWeiboAnalysisResult getWeiboAnalysisResult(Integer id) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("id", id);
        logger.info("submitWeiboAnalysis=" + ((Object)map).toString());
        DatasourceRequestProcessor<String, AliWeiboAnalysisResult> processor = new DatasourceRequestProcessor<String, AliWeiboAnalysisResult>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "getWeiboAnalysisResult.do", JSON.toJSONString(map)), new WeiboResultParser());
        return processor.processRequest();
    }

    @Override
    public List<SenSourceFacet> queryOuterNumber(MapParams params) throws Exception {
        Map<String, Object> query = MapQueryBuilderManager.processWithMapProceesor(new ParamsMapQueryProcessor(params));
        logger.info("queryOuterNumber=" + query.toString());
        DatasourceRequestProcessor<String, List<SenSourceFacet>> processor = new DatasourceRequestProcessor<String, List<SenSourceFacet>>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "queryOuterNumber.do", JSON.toJSONString(query)), new SenSourceFacetParser());
        return processor.processRequest();
    }

    @Override
    public List<Emotion> queryEmotion(MapParams params) throws Exception {
        Map<String, Object> query = MapQueryBuilderManager.processWithMapProceesor(new ParamsMapQueryProcessor(params));
        logger.info("queryEmotion=" + query.toString());
        DatasourceRequestProcessor<String, List<Emotion>> processor = new DatasourceRequestProcessor<String, List<Emotion>>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "queryOuterEmotion.do", JSON.toJSONString(query)), new EmotionDataParser(params));
        return processor.processRequest();
    }

    @Override
    public Iterator<HotEvent> queryAllHotEvent(HotParams params) throws Exception {
        PageDataIterator<HotEvent> iterator = new PageDataIterator<HotEvent>(x -> {
            params.setPage(x);
            try {
                return this.queryHotEvent(params);
            }
            catch (Exception e) {
                logger.error((Object)e);
                return null;
            }
        });
        return iterator;
    }

    @Override
    public Iterator<HotNews> queryAllHotNews(HotParams params) throws Exception {
        PageDataIterator<HotNews> iterator = new PageDataIterator<HotNews>(x -> {
            params.setPage(x);
            try {
                return this.queryHotNews(params);
            }
            catch (Exception e) {
                logger.error((Object)e);
                return null;
            }
        });
        return iterator;
    }

    @Override
    public List<Integer> addMonitorKeyword(AliKeywordsAddParams params) {
        logger.info("url =" + ConfigureUtils.chinamcloudurl + "addMonitorKeyword.do");
        logger.info("params =" + JSON.toJSONString((Object)params));
        DatasourceRequestProcessor<String, List<Integer>> processor = new DatasourceRequestProcessor<String, List<Integer>>(new HttpRequestSource(String.valueOf(ConfigureUtils.chinamcloudurl) + "addMonitorKeyword.do", JSON.toJSONString((Object)params)), new AliKeywordsParser());
        return processor.processRequest();
    }
}

