/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.parser.UserInfoDataParser;
import com.chinamcloud.bigdata.haiheservice.util.HttpUtils;
import com.chinamcloud.bigdata.haiheservice.util.MD5;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.http.ParseException;

public class CMCUtils {
    private static final String CONF_PATH = "/config/cmc.properties";
    private static String ak_id = null;
    private static String ak_secret = null;
    private static String ak_serviceKey = null;

    static {
        Properties prop = new Properties();
        try {
            prop.load(new InputStreamReader(CMCUtils.class.getResourceAsStream(CONF_PATH)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ak_id = prop.getProperty("ak_id");
        ak_secret = prop.getProperty("ak_secret");
        ak_serviceKey = prop.getProperty("ak_serviceKey");
    }

    public static String sendGet(String path, Map<String, String> queryParams) {
        String url = CMCUtils.buildUrlWithSign(path, queryParams);
        return HttpUtils.executeGet(url, null, null).getMsg();
    }

    public static String sendPost(String path, Map<String, Object> map) {
        String url = CMCUtils.buildUrlWithSign(path, null);
        return HttpUtils.executePost(url, JSON.toJSONString(map)).getMsg();
    }

    private static String buildUrlWithSign(String path, Map<String, String> queryParams) {
        String url = null;
        try {
            String Timestamp2 = String.valueOf(new Date().getTime());
            TreeMap<String, String> defaultParams = new TreeMap<String, String>();
            defaultParams.put("AccessKeyId", ak_id);
            defaultParams.put("ServiceKey", ak_serviceKey);
            defaultParams.put("Format", "JSON");
            defaultParams.put("SignatureMethod", "HMAC-SHA1");
            defaultParams.put("Timestamp", Timestamp2);
            defaultParams.put("SignatureVersion", "1.0");
            defaultParams.put("SignatureNonce", MD5.md5(Timestamp2));
            if (queryParams != null && queryParams.size() > 0) {
                defaultParams.putAll(queryParams);
            }
            String queryString = "";
            int index = 0;
            for (Map.Entry entry : defaultParams.entrySet()) {
                String key = ((String)entry.getKey()).toString();
                String value = ((String)entry.getValue()).toString();
                queryString = String.valueOf(queryString) + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
                if (index < defaultParams.size() - 1) {
                    queryString = String.valueOf(queryString) + "&";
                }
                ++index;
            }
            String signQueryString = "GET&%2F&" + URLEncoder.encode(queryString, "UTF-8");
            String signature = MD5.hmacSha1(signQueryString, String.valueOf(ak_secret) + "&");
            queryString = String.valueOf(queryString) + "&Signature=" + URLEncoder.encode(signature, "UTF-8");
            url = String.valueOf(path) + "?" + queryString;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    public static void main(String[] args) throws ParseException, IOException, URISyntaxException {
        String result = "";
        String path = "";
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.clear();
        queryParams.put("user_token", "0362e1e9732db33afa2f1d3269f5c97c");
        path = "https://cmcconsole.chinamcloud.com/interface/get-user-info-by-token";
        result = CMCUtils.sendGet(path, queryParams);
        System.out.println(result);
        UserInfoDataParser parser = new UserInfoDataParser();
        User user = parser.parseRecords(result);
        System.out.println(user);
    }

    public void report() {
        User user = new User();
        user.setUserToken("0362e1e9732db33afa2f1d3269f5c97c");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user_token", user.getUserToken());
        map.put("report_time", format.format(new Date()));
        ArrayList report_data = new ArrayList();
        HashMap<String, String> report = new HashMap<String, String>();
        report.put("item_code", "topic");
        report.put("report_type", "1");
        report.put("qota_value", "1");
        report_data.add(report);
        map.put("report_data", report_data);
        String path = "https://cmcconsole.chinamcloud.com/interface/report-by-token";
        String result = CMCUtils.sendPost(path, map);
        System.out.println(result);
    }
}

