/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.AttributeConverter;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class DBUtils {
    public static ParamSQLWrapper buildInsertSQL(Object object, boolean ignoreNull) throws IllegalAccessException, InstantiationException {
        Class<?> classz = object.getClass();
        String tableName = DBUtils.getTableName(classz);
        List<FieldWrapper> fieldWrappers = DBUtils.getFields(classz);
        LinkedList<String> colunms = new LinkedList<String>();
        LinkedList<Object> values = new LinkedList<Object>();
        Object o = null;
        for (FieldWrapper wrapper : fieldWrappers) {
            o = FieldUtils.readField((Field)wrapper.getField(), (Object)object, (boolean)true);
            if (ignoreNull && o == null) continue;
            Class convertClass = null;
            Convert convert = wrapper.getField().getAnnotation(Convert.class);
            if (convert != null) {
                convertClass = convert.converter();
            }
            if (convertClass != null) {
                Object value = ((AttributeConverter)convertClass.newInstance()).convertToDatabaseColumn(o);
                values.add(!StringUtils.isEmpty((CharSequence)String.valueOf(value)) ? value : null);
            } else {
                values.add(!StringUtils.isEmpty((CharSequence)String.valueOf(o)) ? o : null);
            }
            colunms.add("`" + wrapper.getColunm() + "`");
        }
        if (colunms.size() == 0) {
            throw new RuntimeException("colunms is 0");
        }
        Object[] params = new String[colunms.size()];
        Arrays.fill(params, "?");
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(tableName).append("(");
        builder.append(StringUtils.join(colunms, (String)","));
        builder.append(")");
        builder.append(" values(");
        builder.append(StringUtils.join((Object[])params, (String)","));
        builder.append(")");
        return new ParamSQLWrapper(builder.toString(), values);
    }

    public static ParamSQLWrapper buildInsertSQL(Object o) throws IllegalAccessException, InstantiationException {
        return DBUtils.buildInsertSQL(o, true);
    }

    public static ParamSQLWrapper buildUpdateSQL(Object o) throws IllegalAccessException, InstantiationException {
        return DBUtils.buildUpdateSQL(o, true);
    }

    public static ParamSQLWrapper buildUpdateSQL(Object object, boolean ignoreNull) throws IllegalAccessException, InstantiationException {
        Class<?> classz = object.getClass();
        String tableName = DBUtils.getTableName(classz);
        List<FieldWrapper> fieldWrappers = DBUtils.getFields(classz);
        LinkedList<String> colunms = new LinkedList<String>();
        LinkedList<Object> values = new LinkedList<Object>();
        LinkedList<String> keyColunms = new LinkedList<String>();
        LinkedList<Object> keyValue = new LinkedList<Object>();
        Object o = null;
        for (FieldWrapper wrapper : fieldWrappers) {
            Field field = wrapper.getField();
            o = FieldUtils.readField((Field)field, (Object)object, (boolean)true);
            if (field.getAnnotation(Id.class) != null) {
                if (o == null) {
                    throw new RuntimeException("the db row key can not be null[" + wrapper.getColunm() + "]");
                }
                keyColunms.add(String.valueOf(wrapper.getColunm()) + "=?");
                keyValue.add(DBUtils.convertValue(field, o));
                continue;
            }
            if (ignoreNull && o == null) continue;
            values.add(DBUtils.convertValue(field, o));
            colunms.add("`" + wrapper.getColunm() + "`=?");
        }
        if (keyColunms.size() == 0) {
            throw new RuntimeException("no key id");
        }
        if (colunms.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ").append(tableName).append(" SET ");
        builder.append(StringUtils.join(colunms, (String)","));
        builder.append(" where ").append(StringUtils.join((Object[])keyColunms.toArray()));
        values.addAll(keyValue);
        return new ParamSQLWrapper(builder.toString(), values);
    }

    private static Object convertValue(Field field, Object o) throws InstantiationException, IllegalAccessException {
        Class convertClass = null;
        Convert convert = field.getAnnotation(Convert.class);
        if (convert != null) {
            convertClass = convert.converter();
        }
        if (convertClass != null) {
            Object value = ((AttributeConverter)convertClass.newInstance()).convertToDatabaseColumn(o);
            return !StringUtils.isEmpty((CharSequence)String.valueOf(value)) ? value : null;
        }
        return !StringUtils.isEmpty((CharSequence)String.valueOf(o)) ? o : null;
    }

    private static String getTableName(Class<?> clazz) {
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity == null) {
            throw new RuntimeException("obejct is not a entity");
        }
        Table table = clazz.getAnnotation(Table.class);
        String tableName = clazz.getSimpleName();
        if (table != null) {
            tableName = table.name();
        }
        return tableName;
    }

    private static List<FieldWrapper> getFields(Class<?> clazz) {
        return FieldUtils.getAllFieldsList(clazz).stream().filter(x -> x.getAnnotation(Transient.class) == null && !Modifier.isStatic(x.getModifiers())).map(x -> {
            FieldWrapper wrapper = new FieldWrapper((Field)x);
            Column column = x.getAnnotation(Column.class);
            if (column != null) {
                wrapper.setColunm(column.name());
            } else {
                wrapper.setColunm(x.getName());
            }
            return wrapper;
        }).collect(Collectors.toList());
    }

    static class FieldWrapper {
        private final Field field;
        private String colunm;

        public Field getField() {
            return this.field;
        }

        public String getColunm() {
            return this.colunm;
        }

        public void setColunm(String colunm) {
            this.colunm = colunm;
        }

        public FieldWrapper(Field field) {
            this.field = field;
        }
    }

    public static class ParamSQLWrapper {
        private final String sql;
        private final Object[] paramValues;

        public String getSql() {
            return this.sql;
        }

        public Object[] getParamValues() {
            return this.paramValues;
        }

        public ParamSQLWrapper(String sql, List<Object> paramValues) {
            this.sql = sql;
            this.paramValues = paramValues.toArray();
        }
    }
}

