/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import com.chinamcloud.bigdata.haiheservice.bean.EmailBean;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailUtils {
    private EmailUtils() {
    }

    public static boolean sendEmail(EmailBean bean) {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", bean.getSmptHost());
        props.setProperty("mail.smtp.port", bean.getSmptPort());
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.ssl.enable", "true");
        Session session = Session.getInstance((Properties)props);
        session.setDebug(true);
        Transport transport = null;
        try {
            try {
                MimeMessage message = EmailUtils.createMimeMessage(session, bean);
                transport = session.getTransport();
                transport.connect(bean.getAccount(), bean.getPassword());
                transport.sendMessage((Message)message, message.getAllRecipients());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (transport != null) {
                        transport.close();
                    }
                }
                catch (MessagingException e2) {
                    e2.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                if (transport != null) {
                    transport.close();
                }
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static MimeMessage createMimeMessage(Session session, EmailBean bean) throws Exception {
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(bean.getAccount(), bean.getNickname(), "UTF-8"));
        for (String receiver : bean.getReceiver()) {
            message.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(receiver, "", "UTF-8"));
        }
        message.setSubject(bean.getSubject(), "UTF-8");
        message.setContent((Object)bean.getMessage(), "text/html;charset=UTF-8");
        message.setSentDate(new Date());
        message.saveChanges();
        return message;
    }
}

