/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import com.chinamcloud.bigdata.haiheservice.bean.AnalysisRecord;
import com.chinamcloud.bigdata.haiheservice.util.ConfigureUtils;
import com.chinamcloud.bigdata.haiheservice.util.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Component;

@Component
public class WeiboUtils {
    private static final Log logger = LogFactory.getLog(WeiboUtils.class);
    public static final List<Header> reqheaders = new ArrayList<Header>();

    static {
        Properties properties = new Properties();
        try {
            logger.info((Object)"loading weiboheaders.properties");
            properties.load(ConfigureUtils.class.getResourceAsStream("/config/weiboheaders.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("load weiboheaders.properties failed");
        }
        logger.info((Object)"loaded weiboheaders.properties");
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        entrySet.forEach(x -> reqheaders.add((Header)new BasicHeader(x.getKey().toString(), x.getValue().toString())));
    }

    public static Integer getWeiboForwards(String url) throws Exception {
        Integer forwards = null;
        int retryTimes = 0;
        block6: while (retryTimes < 5) {
            try {
                String topicHtml = HttpUtils.executeGet(url, null, reqheaders.toArray(new Header[reqheaders.size()])).getMsg();
                Document doc = Jsoup.parse((String)topicHtml);
                Elements eles = doc.getElementsByTag("script");
                for (Element item : eles) {
                    String htmlTxt = item.html();
                    if (!htmlTxt.contains("pl.content.weiboDetail.index")) continue;
                    htmlTxt = htmlTxt.substring(htmlTxt.indexOf("<div"), htmlTxt.lastIndexOf("div>") + 4).replace("\\t", "").replace("\\n", "").replace("\\r", "").replace("\\", "");
                    Document topicDoc = Jsoup.parse((String)htmlTxt);
                    Elements feedEles = topicDoc.select("[node-type=feed_list_options]").select("li");
                    try {
                        Elements forwardsEles = feedEles.select("[node-type=forward_btn_text]");
                        forwards = Integer.parseInt(((Element)forwardsEles.select("em").get(1)).text());
                    }
                    catch (Exception exception) {}
                    break block6;
                }
                break;
            }
            catch (Exception e) {
                logger.error((Object)(e + " - get weibo forwards error. url:" + url + ", RetryTimes:" + retryTimes));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++retryTimes;
            }
        }
        return forwards;
    }

    public static final AnalysisRecord getWeiboDoc(String url) {
        AnalysisRecord weiboDoc = null;
        int retryTimes = 0;
        block10: while (retryTimes < 5) {
            try {
                String topicHtml = HttpUtils.executeGet(url, null, reqheaders.toArray(new Header[reqheaders.size()])).getMsg();
                if ("unknown".equals(topicHtml)) {
                    return weiboDoc;
                }
                Document doc = Jsoup.parse((String)topicHtml);
                Elements eles = doc.getElementsByTag("script");
                for (Element item : eles) {
                    Elements contentEles;
                    String content;
                    String htmlTxt = item.html();
                    if (!htmlTxt.contains("pl.content.weiboDetail.index")) continue;
                    weiboDoc = new AnalysisRecord();
                    weiboDoc.setUrl(url);
                    url = url.replace("http://", "");
                    String uid = url.split("\\/")[1];
                    weiboDoc.setUid(uid);
                    htmlTxt = htmlTxt.substring(htmlTxt.indexOf("<div"), htmlTxt.lastIndexOf("div>") + 4).replace("\\t", "").replace("\\n", "").replace("\\r", "").replace("\\", "");
                    Document topicDoc = Jsoup.parse((String)htmlTxt);
                    Elements wbInfoEles = topicDoc.select("[class=WB_info]").select("a");
                    weiboDoc.setScreenName(((Element)wbInfoEles.get(0)).text());
                    Elements fromEles = topicDoc.select("[class=WB_from S_txt2]").select("a");
                    if (!fromEles.isEmpty()) {
                        Date createTime = WeiboUtils.parseDate(((Element)fromEles.get(0)).html());
                        weiboDoc.setCreateAt(createTime);
                        if (fromEles.size() > 1) {
                            String source = ((Element)fromEles.get(1)).text().replaceAll("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", "***");
                            weiboDoc.setSource("\u6765\u81ea " + source);
                        }
                    }
                    if ((content = (contentEles = topicDoc.select("[node-type=feed_list_content]")).text()).length() > 512) {
                        content = String.valueOf(content.substring(0, 500)) + "...";
                    }
                    content = content.replaceAll("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", "***");
                    weiboDoc.setContent(content);
                    Elements picElements = topicDoc.select("[action-type=fl_pics]");
                    if (!picElements.isEmpty()) {
                        ArrayList<String> imgList = new ArrayList<String>();
                        Elements imgElements = picElements.select("img");
                        int i = 0;
                        while (i < imgElements.size()) {
                            imgList.add(((Element)imgElements.get(i)).attr("src"));
                            ++i;
                        }
                        weiboDoc.setProfileImageURL(StringUtils.join(imgList, (String)";"));
                    } else {
                        String imgUrl;
                        Elements thumPicElements = topicDoc.select("[node-type=fl_h5_video_pre]").select("img");
                        if (!thumPicElements.isEmpty()) {
                            imgUrl = thumPicElements.attr("src");
                            weiboDoc.setProfileImageURL(imgUrl);
                        } else {
                            thumPicElements = topicDoc.select("[node-type=feed_list_media_prev]").select("img");
                            if (!thumPicElements.isEmpty()) {
                                imgUrl = thumPicElements.attr("src");
                                weiboDoc.setProfileImageURL(imgUrl);
                            }
                        }
                    }
                    Elements feedEles = topicDoc.select("[node-type=feed_list_options]").select("li");
                    long forwards = 0L;
                    try {
                        Elements forwardsEles = feedEles.select("[node-type=forward_btn_text]");
                        forwards = Long.parseLong(((Element)forwardsEles.select("em").get(1)).text());
                    }
                    catch (Exception forwardsEles) {
                        // empty catch block
                    }
                    long comments = 0L;
                    try {
                        Elements commentsEle = feedEles.select("[node-type=comment_btn_text]");
                        comments = Long.parseLong(((Element)commentsEle.select("em").get(1)).text());
                    }
                    catch (Exception commentsEle) {
                        // empty catch block
                    }
                    long thumbs = 0L;
                    try {
                        Elements thumbsEle = feedEles.select("[node-type=like_status]");
                        Elements likesList = ((Element)thumbsEle.get(thumbsEle.size() - 1)).getElementsByTag("em");
                        thumbs = Long.parseLong(((Element)likesList.select("em").get(1)).text());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    weiboDoc.setForwards(forwards);
                    weiboDoc.setComments(comments);
                    weiboDoc.setThumbs(thumbs);
                    break block10;
                }
                break;
            }
            catch (Exception e) {
                logger.error((Object)(e + "- get weibo doc error. retryTimes:" + retryTimes));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++retryTimes;
            }
        }
        return weiboDoc;
    }

    private static Date parseDate(String text) {
        String dateText = null;
        if (text.contains("\u5206\u949f\u524d")) {
            int minutes = Integer.parseInt(text.replace("\u5206\u949f\u524d", ""));
            DateTime dateTime = DateTime.now().minusMinutes(minutes);
            dateText = dateTime.toString("yyyy-MM-dd HH:mm");
        } else if (text.contains("\u4eca\u5929")) {
            String todayText = DateTime.now().toString("yyyy-MM-dd");
            String timeText = text.split(" ")[1];
            dateText = String.valueOf(todayText) + " " + timeText;
        } else if (text.contains("\u6708")) {
            int month = Integer.parseInt(text.substring(0, text.indexOf("\u6708")));
            int day = Integer.parseInt(text.substring(text.indexOf("\u6708") + 1, text.indexOf("\u65e5")));
            String timeText = text.split(" ")[1];
            int year = Calendar.getInstance().get(1);
            dateText = String.valueOf(year) + "-" + (month >= 10 ? Integer.valueOf(month) : "0" + month) + "-" + (day >= 10 ? Integer.valueOf(day) : "0" + day) + " " + timeText;
        } else {
            int year = Integer.parseInt(text.split("-")[0]);
            int month = Integer.parseInt(text.split("-")[1]);
            int day = Integer.parseInt(text.split("-")[2].split(" ")[0]);
            String timeText = text.split(" ")[1];
            dateText = String.valueOf(year) + "-" + (month >= 10 ? Integer.valueOf(month) : "0" + month) + "-" + (day >= 10 ? Integer.valueOf(day) : "0" + day) + " " + timeText;
        }
        DateTime dateTime = DateTime.parse((String)dateText, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"));
        return new Date(dateTime.getMillis());
    }

    public static void main(String[] args) {
        String str = "https://weibo.com/5909872726/FCyuSpkpU";
        AnalysisRecord result = WeiboUtils.getWeiboDoc(str);
        System.out.println(result);
    }
}

