/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.xz;

import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.bean.PageResult;
import com.chinamcloud.bigdata.haiheservice.bean.SearchResult;
import com.chinamcloud.bigdata.haiheservice.xz.IAliDataParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.kelude.common.PagedResult;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PageParser<T, M>
extends PageResult<M>
implements IAliDataParser<Page<T>> {
    private static Logger logger = LogManager.getLogger(PageParser.class);

    @Override
    public Page<T> parserData(String data) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aaa", Locale.ENGLISH));
        SearchResult result = null;
        try {
            Type type = this.getClass().getGenericSuperclass();
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            JavaType javaType = mapper.getTypeFactory().constructParametrizedType(PageResult.class, PageResult.class, new Class[]{Class.forName(parameterizedType.getActualTypeArguments()[1].getTypeName())});
            result = (PageResult)mapper.readValue(data, javaType);
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("page parser error", (Throwable)e);
        }
        if (result != null && result.isSuccess()) {
            PagedResult pageResult = ((PageResult)result).getData();
            List<T> t = this.parseRecords(pageResult.getResult());
            Page<T> page = new Page<T>(t);
            page.setPageSize(pageResult.getPageSize());
            page.setTotalCount(pageResult.getTotalCount());
            page.setTotalPages(pageResult.getTotalPages());
            return page;
        }
        return new Page(Collections.emptyList());
    }

    protected abstract List<T> parseRecords(M var1);
}

