/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice;

import com.chinamcloud.bigdata.haiheservice.bean.MonitorTopic;
import com.chinamcloud.bigdata.haiheservice.service.RegionService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonitorTopicManager {
    private Map<String, MonitorTopic> name2MonitorTopic = new HashMap<String, MonitorTopic>();
    private Map<Integer, MonitorTopic> id2MonitorTopic = new HashMap<Integer, MonitorTopic>();
    private Map<MonitorTopic.Type, Set<MonitorTopic>> type2MonitorTopic = new HashMap<MonitorTopic.Type, Set<MonitorTopic>>();
    @Autowired
    private RegionService regionService;

    protected void init() {
        List<MonitorTopic> monitorTopics = this.regionService.selectRegionTopics();
        monitorTopics.forEach(x -> {
            this.name2MonitorTopic.put(x.getName(), (MonitorTopic)x);
            this.id2MonitorTopic.put(x.getMonitorTopicId(), (MonitorTopic)x);
            Set<MonitorTopic> set = this.type2MonitorTopic.get((Object)x.getType());
            if (set == null) {
                set = new HashSet<MonitorTopic>();
                this.type2MonitorTopic.put(x.getType(), set);
            }
            set.add((MonitorTopic)x);
        });
    }

    public Integer findMonitorTopicIdByName(String name) {
        MonitorTopic monitorTopic = this.name2MonitorTopic.get(name);
        return monitorTopic == null ? null : monitorTopic.getMonitorTopicId();
    }

    public String findMonitorTopicNameById(Integer id) {
        MonitorTopic mapping = this.id2MonitorTopic.get(id);
        return mapping == null ? "" : mapping.getName();
    }

    public Set<MonitorTopic> findMonitorsByType(MonitorTopic.Type type) {
        return this.type2MonitorTopic.get((Object)type);
    }
}

