/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice;

import com.chinamcloud.bigdata.haiheservice.DatasourceRequestProcessor;
import com.chinamcloud.bigdata.haiheservice.IDataParser;
import com.chinamcloud.bigdata.haiheservice.PageRequestSource;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PageRequestProcessor<T>
extends DatasourceRequestProcessor<String, Page<T>> {
    private static Logger logger = LogManager.getLogger(PageRequestProcessor.class);
    private PageRequestSource source;
    private final int MAX_RETRY = 5;

    public <I> PageRequestProcessor(PageRequestSource pageRequestSource, IDataParser<String, Page<T>> parser) {
        super(pageRequestSource, parser);
        this.source = pageRequestSource;
    }

    @Override
    public Page<T> processRequest() {
        Page pages = new Page(new LinkedList());
        int currentPageSize = this.source.getPageSize();
        pages.setPageSize(currentPageSize);
        int retry = 0;
        while (retry < 5) {
            Page page = (Page)super.processRequest();
            this.merge(pages, page, currentPageSize);
            int currentPageIndex = this.source.getPageIndex();
            int size = page.getRecords().size();
            if (pages.getRecords().size() >= currentPageSize || size <= 0 || page.getTotalPages() <= currentPageIndex) break;
            this.source.incrementPageIndex();
        }
        this.afterProcessor(pages);
        return pages;
    }

    public void afterProcessor(Page<T> pages) {
    }

    public void merge(Page<T> page, Page<T> newPage, int size) {
        int newCount = newPage.getTotalCount();
        if (page.getTotalCount() == 0) {
            page.setTotalCount(newCount);
            page.setTotalPages(newPage.getTotalPages());
        }
        int i = 0;
        do {
            int diffSize;
            if ((diffSize = size - page.getRecords().size()) > 0) {
                List<T> newRecords = newPage.getRecords();
                int min = Math.min(diffSize + i, newRecords.size());
                List<T> newList = newRecords.subList(i, min);
                page.getRecords().addAll(this.filterList(newList));
                i += diffSize;
            }
            this.mergeList(page.getRecords());
        } while (page.getRecords().size() < size && newPage.getRecords().size() > i);
    }

    private List<T> filterList(List<T> list) {
        LinkedList<T> filtersList = new LinkedList<T>();
        for (T t : list) {
            if (!this.filter(t)) continue;
            filtersList.add(t);
        }
        return filtersList;
    }

    public void mergeList(List<T> list) {
    }

    public boolean filter(T t) {
        return true;
    }

    static class DataChangeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        DataChangeException() {
        }
    }
}

