/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice;

import com.chinamcloud.bigdata.haiheservice.IMapQueryProcessor;
import com.chinamcloud.bigdata.haiheservice.pojo.MapParams;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ParamsMapQueryProcessor
implements IMapQueryProcessor {
    private Map<String, Object> query = new HashMap<String, Object>();
    private MapParams params;

    public ParamsMapQueryProcessor(MapParams params) {
        this.params = params;
    }

    protected void setMapParams() {
        this.setMonitorTopicId().setTime().setTimeType().setSourceType().setSourceIdentifier().setProductId();
    }

    protected ParamsMapQueryProcessor setMonitorTopicId() {
        Integer monitorTopicId = this.params.getMonitorTopicId();
        if (monitorTopicId == null) {
            monitorTopicId = 0;
        }
        this.query.put("keyWordTopicId", monitorTopicId);
        return this;
    }

    protected ParamsMapQueryProcessor setTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(new Date());
        if (this.params.getTime() != null) {
            currentDate.setTime(this.params.getTime());
        }
        this.query.put("time", formatter.format(currentDate.getTime()));
        return this;
    }

    protected ParamsMapQueryProcessor setTimeType() {
        String timeType = this.params.getTimeType();
        this.query.put("timeType", timeType);
        return this;
    }

    protected ParamsMapQueryProcessor setSourceType() {
        if (!StringUtils.isEmpty((CharSequence)this.params.getSourceType())) {
            this.query.put("sourceType", this.params.getSourceType());
        }
        return this;
    }

    protected ParamsMapQueryProcessor setSourceIdentifier() {
        if (!StringUtils.isEmpty((CharSequence)this.params.getSourceIdentifier())) {
            this.query.put("sourceIdentifier", this.params.getSourceIdentifier());
        }
        return this;
    }

    protected ParamsMapQueryProcessor setProductId() {
        if (this.params.getProductId() != null) {
            this.query.put("productId", this.params.getProductId());
        }
        return this;
    }

    @Override
    public void process(Map<String, Object> query) throws Exception {
        this.query = query;
        this.setMapParams();
    }
}

