/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller.dp;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EventStatisticAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.TopicStatisticAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.KeyWords;
import com.chinamcloud.bigdata.haiheservice.bean.MonitorTopic;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.pojo.TopicHotEventParams;
import com.chinamcloud.bigdata.haiheservice.service.MonitorTopicService;
import com.chinamcloud.bigdata.haiheservice.util.TopicKeywordUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/dp/topic"})
public class DpTopicHotController {
    private static Logger logger = LogManager.getLogger(DpTopicHotController.class);
    private static final List<Integer> productIds = new ArrayList<Integer>();
    @Autowired
    private MonitorTopicService monitorTopicService;

    @RequestMapping(value={"/getDefineTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object selectUserDefineTopic(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        Long userId = user.getId();
        List<MonitorTopic> list = this.monitorTopicService.selectUserSubDefineTopics(userId);
        list.forEach(x -> {
            Long uid = x.getUid();
            x.setOwner(uid != null && userId.equals(uid) ? (byte)1 : (byte)0);
        });
        return CodeResult.successResult(null, list);
    }

    @RequestMapping(value={"/getEventStatistics"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getEventStatistics(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(productIds);
        params.setAfterProcessor(new EventStatisticAfterProcessor());
        ModelAndView view = new ModelAndView("/es/basic/eventStatistics.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getEventTrend"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getEventTrend(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/eventTrend.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getTopicStatistics"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getTopicStatistics(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setProduceIds(productIds);
        params.setFacetMincount(1);
        params.setAfterProcessor(new TopicStatisticAfterProcessor());
        ModelAndView view = new ModelAndView("/es/basic/topicStatistics.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/news"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object hotNews(@RequestBody @Validated TopicHotEventParams params, BindingResult result, HttpServletRequest request) {
        Long topicId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        String description = TopicKeywordUtils.buildQueryByObject(keyWords);
        params.setDescription(description);
        logger.info("description=" + description);
        params.setProduceIds(productIds);
        ModelAndView modelAndView = new ModelAndView("/es/basic/hotNews.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/getHotWords"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getHotWords(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        HotParams hotParams = new HotParams();
        hotParams.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        hotParams.setProduceIds(productIds);
        hotParams.setFacetField("summary_keywords");
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getSenSourceFacet"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getSentimentSourceFacet(@Validated @RequestBody TopicHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        Long topicId;
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            topicId = Long.valueOf(params.getTopicId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        params.setDescription(TopicKeywordUtils.buildQueryByObject(keyWords));
        params.setFacetField("tb_nickname");
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    static {
        productIds.add(53691);
        productIds.add(2762);
    }
}

