/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.AlarmGradeBean;
import com.chinamcloud.bigdata.haiheservice.util.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class AlarmGrade {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public Long saveAlarmGrade(AlarmGradeBean alarmGradeBean) {
        DBUtils.ParamSQLWrapper sqlWarpper = null;
        try {
            sqlWarpper = DBUtils.buildInsertSQL(alarmGradeBean, true);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        final DBUtils.ParamSQLWrapper tempWrapper = sqlWarpper;
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement statement = con.prepareStatement(tempWrapper.getSql(), 1);
                ArgumentPreparedStatementSetter statementSetter = new ArgumentPreparedStatementSetter(tempWrapper.getParamValues());
                statementSetter.setValues(statement);
                return statement;
            }
        }, (KeyHolder)keyHolder);
        long id = keyHolder.getKey().longValue();
        return id;
    }

    public List<AlarmGradeBean> getAlarmGradeBean(Long taskId) {
        String sql = "select * from `t_alarm_grade` grade where grade.taskId = ?";
        List query = this.jdbcTemplate.query(sql, new Object[]{taskId}, (RowMapper)new RowMapper<AlarmGradeBean>(){

            public AlarmGradeBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                AlarmGradeBean bean = new AlarmGradeBean();
                bean.setId(rs.getInt("id"));
                bean.setUserId(rs.getLong("userId"));
                bean.setTaskId(rs.getLong("taskId"));
                bean.setAlarmGrade(rs.getString("alarm_grade"));
                bean.setDocValue(rs.getLong("doc_value"));
                bean.setMaxEmotionValue(rs.getLong("max_emotion_value"));
                bean.setMediaValue(rs.getLong("media_value"));
                return bean;
            }
        });
        return query;
    }

    public List<AlarmGradeBean> getAlarmGradeBean(Long taskId, Long userId) {
        String sql = "select * from `t_alarm_grade` grade where grade.taskId = ? and grade.userId = ?";
        List query = this.jdbcTemplate.query(sql, new Object[]{taskId, userId}, (RowMapper)new RowMapper<AlarmGradeBean>(){

            public AlarmGradeBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                AlarmGradeBean bean = new AlarmGradeBean();
                bean.setId(rs.getInt("id"));
                bean.setUserId(rs.getLong("userId"));
                bean.setTaskId(rs.getLong("taskId"));
                bean.setAlarmGrade(rs.getString("alarm_grade"));
                bean.setDocValue(rs.getLong("doc_value"));
                bean.setMaxEmotionValue(rs.getLong("max_emotion_value"));
                bean.setMediaValue(rs.getLong("media_value"));
                return bean;
            }
        });
        return query;
    }

    public boolean updateContactor(AlarmGradeBean bean) {
        DBUtils.ParamSQLWrapper sqlWarpper = null;
        try {
            sqlWarpper = DBUtils.buildUpdateSQL(bean);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        int num = this.jdbcTemplate.update(sqlWarpper.getSql(), sqlWarpper.getParamValues());
        return num == 1;
    }
}

