/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.db.mapper;

import com.chinamcloud.bigdata.haiheservice.bean.MonitorTopic;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.springframework.jdbc.core.RowMapper;

public class MonitorTopicMapper
implements RowMapper<MonitorTopic> {
    private Consumer<MonitorTopic> consumer;
    private boolean hasSubEndTime = true;

    public boolean isHasSubEndTime() {
        return this.hasSubEndTime;
    }

    public void setHasSubEndTime(boolean hasSubEndTime) {
        this.hasSubEndTime = hasSubEndTime;
    }

    public MonitorTopicMapper(Consumer<MonitorTopic> consumer) {
        this.consumer = consumer;
    }

    public MonitorTopicMapper(Consumer<MonitorTopic> consumer, boolean hasSubEndTime) {
        this.consumer = consumer;
        this.hasSubEndTime = hasSubEndTime;
    }

    public MonitorTopicMapper() {
    }

    public MonitorTopicMapper(boolean hasSubEndTime) {
        this.hasSubEndTime = hasSubEndTime;
    }

    public MonitorTopic mapRow(ResultSet rs, int rowNum) throws SQLException {
        MonitorTopic monitorTopic = new MonitorTopic();
        monitorTopic.setId(rs.getLong("id"));
        monitorTopic.setMonitorTopicId(rs.getInt("monitorTopicId"));
        monitorTopic.setProductId(rs.getInt("productId"));
        monitorTopic.setUid(rs.getLong("uid"));
        monitorTopic.setType(MonitorTopic.Type.valueOfInt(rs.getInt("type")));
        monitorTopic.setName(rs.getString("name"));
        monitorTopic.setRegisterTime(rs.getTimestamp("registerTime"));
        monitorTopic.setCreatedAtTime(rs.getTimestamp("createdAtTime"));
        if (this.hasSubEndTime) {
            monitorTopic.setSubEndTime(rs.getTimestamp("subEndTime"));
        }
        monitorTopic.setIncludeSearch(rs.getInt("includeSearch"));
        monitorTopic.setSubscribable(MonitorTopic.Subscribable.valueOfInt(rs.getInt("subscribable")));
        if (this.consumer != null) {
            this.consumer.accept(monitorTopic);
        }
        return monitorTopic;
    }
}

