/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.db.mapper;

import com.chinamcloud.bigdata.haiheservice.bean.MonitorTopic;
import com.chinamcloud.bigdata.haiheservice.db.mapper.MonitorTopicMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;

public class MonitorTopicWithIndexMapper
extends MonitorTopicMapper {
    private Consumer<MonitorTopic> consumer;

    public MonitorTopicWithIndexMapper(Consumer<MonitorTopic> consumer) {
        this.consumer = consumer;
    }

    public MonitorTopicWithIndexMapper() {
    }

    @Override
    public MonitorTopic mapRow(ResultSet rs, int rowNum) throws SQLException {
        this.setHasSubEndTime(false);
        MonitorTopic monitorTopic = super.mapRow(rs, rowNum);
        MonitorTopic.IndexData indexData = new MonitorTopic.IndexData();
        indexData.setDocTotal(rs.getInt("docTotal"));
        indexData.setEmotionTotal(rs.getInt("emotionTotal"));
        indexData.setHotTotal(rs.getInt("hotTotal"));
        indexData.setMediaCoverTotal(rs.getInt("mediaCoverTotal"));
        indexData.setPreDocCount(rs.getInt("pre_doc_count"));
        indexData.setYesterdayDocCount(rs.getInt("yesterday_doc_count"));
        indexData.setPreEmotionValue(rs.getInt("pre_emotion_value"));
        indexData.setYesterdayEmotionValue(rs.getInt("yesterday_emotion_value"));
        indexData.setPreHotValue(rs.getInt("pre_hot_value"));
        indexData.setYesterdayHotValue(rs.getInt("yesterday_hot_value"));
        indexData.setPreMediaCover(rs.getInt("pre_media_cover"));
        indexData.setYesterdayMediaCover(rs.getInt("yesterday_media_cover"));
        monitorTopic.setIndexData(indexData);
        monitorTopic.setRegisterTime(rs.getTimestamp("registerTime"));
        monitorTopic.setCreatedAtTime(rs.getTimestamp("createdAtTime"));
        if (this.consumer != null) {
            this.consumer.accept(monitorTopic);
        }
        return monitorTopic;
    }
}

